#include "CS_AmWindShield.h"
#include "PeSpark.h"
#include "CS_PeGunShotHit.h"
CS_AmWindShield::CS_AmWindShield(std::shared_ptr<Entity> parent, bool bGiant)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ʵĵһܻ֡
	//ùλ
	ud = parent->ud;
	lr = parent->lr;
	dx = lr == 0 ? -32.0f : 32.0f;
	x = parent->x + dx;
	y = parent->y + dy;
	this->bGiant = bGiant;
	//ö
	if (bGiant)
		ani.sprite_index = lr == 0 ? L"am_wind_shield_giant_l" : L"am_wind_shield_giant_r";
	else
		ani.sprite_index = lr == 0 ? L"am_wind_shield_l" : L"am_wind_shield_r";
	//ʱ
	action_timecounter_max = 120;
	action_timecounter = action_timecounter_max;
	//ײ
	if (bGiant)
	{
		if (lr == 0)
		{
			cbRect.left = -8;
			cbRect.right = 40;
			cbRect.top = 24;
			cbRect.bottom = 8;
		}
		else
		{
			cbRect.left = 40;
			cbRect.right = -8;
			cbRect.top = 24;
			cbRect.bottom = 8;
		}
	}
	else
	{
		if (lr == 0)
		{
			cbRect.left = -8;
			cbRect.right = 40;
			cbRect.top = 6;
			cbRect.bottom = 8;
		}
		else
		{
			cbRect.left = 40;
			cbRect.right = -8;
			cbRect.top = 6;
			cbRect.bottom = 8;
		}
	}
}

void CS_AmWindShield::Init(std::weak_ptr<Entity> self)
{
	if (gameFunc->pGameOption_difficulty)
		if (*gameFunc->pGameOption_difficulty == 0)
			bNormalMode = true;
	//ٶ
	float move = 0xe00 / ts;
	if (bNormalMode)
		move = 0x700 / ts;
	vx = lr == 0 ? -move : move;
	//Ч
	auto wlightTail = std::make_shared<PeLightTail>(shared_from_this(), 40, bGiant ? 32.0f : 16.0f);
	lightTail = wlightTail;
	gameFunc->SetEntity(shared_from_this(), wlightTail);
	gameFunc->PlaySound(L"CS_106");
	ActionEntity::Init(self);
}

void CS_AmWindShield::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//ʧ
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
		{
			vx = 0;
			vy = 0;
			ani.image_index = 0;
			if (bGiant)
				ani.sprite_index = lr == 0 ? L"am_wind_shield_giant_explode_l" : L"am_wind_shield_giant_explode_r";
			else
				ani.sprite_index = lr == 0 ? L"am_wind_shield_explode_l" : L"am_wind_shield_explode_r";
			explode = true;
			auto wlightTail = lightTail.lock();
			if (wlightTail)
				wlightTail->Leave();
		}
	}
	if (!explode && (!attackState || (cbRect.cbLeft && lr == 0) || (cbRect.cbRight && lr != 0)))
	{
		action_timecounter = 0;
		vx = 0;
		vy = 0;
		ani.image_index = 0;
		if (bGiant)
			ani.sprite_index = lr == 0 ? L"am_wind_shield_giant_explode_l" : L"am_wind_shield_giant_explode_r";
		else
			ani.sprite_index = lr == 0 ? L"am_wind_shield_explode_l" : L"am_wind_shield_explode_r";
		explode = true;
		auto wlightTail = lightTail.lock();
		if (wlightTail)
			wlightTail->Leave();
	}
	//ը
	if (explode && ani.image_index >= 4)
	{
		inUsing = false;
	}
}

void CS_AmWindShield::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 5;
	if (lr == 0)
		*outAngle = 225;
	else
		*outAngle = 315;
	*outTakedown = true;
	*outElemType = 0;
	if (bGiant)
		*outShockForce = 0xc00 / ts;
	else
		*outShockForce = 0x800 / ts;
	if (bNormalMode)
		*outShockForce /= 2.0f;
	*outHeavy = 2;
}

void CS_AmWindShield::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if(realDamage > 0)
	{ 
		auto pe = gameFunc->GameCreateEntity(L"pe_blade");
		pe->x = x;
		pe->y = y;
		gameFunc->SetEntity(shared_from_this(), pe);
		SetPeSpark(shared_from_this(), centerX, centerY, 1, 3, lr == 0 ? 180.0f : 0);
		//
		gameFunc->PlaySound(L"AMBlade");
	}
}
