#include "CS_AmPhoton.h"
#include "CS_PePhoton.h"
#include "CS_PeSmoke.h"
CS_AmPhoton::CS_AmPhoton(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	lr = parent->lr;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 4;
	hp_max = hp = 2;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_photon";
	//
	speedDir = true;
}

void CS_AmPhoton::Step()
{
	auto& ani_no = ani.image_index;
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		Destroy();
		SetCS_PePhoton(shared_from_this(), x, y);
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	if (++ani_wait > 1)
	{
		ani_wait = 0;

		if (++ani_no > 2)
			ani_no = 0;
	}

	if (++count1 > 150)
	{
		SetCS_PePhoton(shared_from_this(), x, y);
		Destroy();
	}
}

void CS_AmPhoton::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 2;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_AmPhoton::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		Destroy();
	}
	return true;
}

void CS_AmPhoton::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void SetCS_AmPhoton(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmPhoton>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
}
