#include "CS_AmNekoPunch.h"

CS_AmNekoPunch::CS_AmNekoPunch(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 26;
	//ö
	ani.png = L"CS_CaveStoryMod";
	action_timecounter = action_timecounter_max = 30;
}

void CS_AmNekoPunch::Init(std::weak_ptr<Entity> self)
{
	gameFunc->PlaySound(L"CS_103_curly_charge_gun");
	Entity::Init(self);
}

void CS_AmNekoPunch::Step()
{
	if (warning_count > 0)
	{
		warning_count--;
		if (warning_count == 0)
		{
			attackTime = 5;
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 5, 0);
			gameFunc->PlaySound(L"CS_026_quake");
			ani.sprite_index = lr == 0 ? L"am_nekopunch_l" : L"am_nekopunch_r";
		}
	}
	else
	{
		if (attackTime > 0)
			attackTime--;
		if (action_timecounter > 0)
			action_timecounter--;
		color = RGBA(0xff, 0xff, 0xff, (BYTE)(0xff * action_timecounter / action_timecounter_max));
		if (action_timecounter == 0)
			Destroy();
	}
}

void CS_AmNekoPunch::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"am_nekopunch_flash_l" : L"am_nekopunch_flash_r";
}

void CS_AmNekoPunch::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (attackTime > 0)
	{
		*outDamage = 5;
		if (lr == 0)
			*outAngle = 225;
		else
			*outAngle = 315;
		*outTakedown = true;
		*outElemType = 0;
		*outShockForce = 0x800 / ts;
		*outHeavy = 2;
	}
}

std::shared_ptr<Entity> CreateCS_AmNekoPunch()
{
	return std::make_shared<CS_AmNekoPunch>(nullptr);
}
