#include "CS_AmFishMissileBig.h"
#include "CS_PeSmoke.h"
#include "CS_PeBooster.h"
#include <PeSmog.h>
CS_AmFishMissileBig::CS_AmFishMissileBig(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 16;
	hp = hp_max = 32;
	//ö
	ani.sprite_index = L"am_fishmissile_big";
}

void CS_AmFishMissileBig::Init(std::weak_ptr<Entity> self)
{
	if (gameFunc->pGameOption_difficulty)
		if (*gameFunc->pGameOption_difficulty == 0)
			bNormalMode = true;
	Entity::Init(self);
}

void CS_AmFishMissileBig::Step()
{
	auto& ani_no = ani.image_index;
	if (!ani.png.length())
		ani.png = L"CS_CaveStoryMod";
	switch (act_no)
	{
	case 0:
		act_no = 1;
		switch (lr)
		{
		case 0:
			angle = 225;
			break;

		case 1:
			angle = 315;
			break;

		case 2:
			angle = 45;
			break;

		case 3:
			angle = 135;
			break;
		}
		[[fallthrough]];
	case 1:
		//  NPC λãԲ˶
		if (bNormalMode)
		{
			vx = 2 * cosf(angle * deg2rad);
			vy = 2 * sinf(angle * deg2rad);
		}
		else
		{
			vx = 4 * cosf(angle * deg2rad);
			vy = 4 * sinf(angle * deg2rad);
		}
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				// ָҵķ
				float dx = wplayer->x - x;
				float dy = wplayer->y - y;
				float dir_rad = atan2f(dy, dx);
				float dir_deg = dir_rad / deg2rad;
				if (dir_deg < 0)
					dir_deg += 360.0f;
				// ƽǶ
				float angle_diff = fmodf(dir_deg - angle + 360.0f, 360.0f);
				if (angle_diff > 180.0f)
					angle_diff -= 360.0f;

				if (angle_diff > 1.0f)
					angle += 360.0f / 256.0f;// ˳ʱ΢
				else if (angle_diff < -1.0f)
					angle -= 360.0f / 256.0f; // ʱ΢
				// ȷǶ 0~360
				if (angle > 360.0f)
					angle -= 360.0f;
				if (angle < 0.0f)
					angle += 360.0f;
				//ҹ
				if (dx * dx + dy * dy < 16 * 16)
					Explode();
			}
		}
		break;
	}
	//ִ˶
	Entity::Step();
	if (++ani_wait > 2)
	{
		ani_wait = 0;
		auto pe = std::make_shared<CS_PeBooster>(4);
		pe->x = x - cosf(angle * deg2rad) * 16;
		pe->y = y - sinf(angle * deg2rad) * 16;
		pe->vx = 0;
		pe->vy = 0;
		pe->drawBeforeOtherEntity = false;
		gameFunc->SetEntity(shared_from_this(), pe);
	}
	ani_no = (int)((angle / 360.0f * 256.0f) + 16.0f) / 32;
	if (ani_no > 7)
		ani_no = 7;
	if (bExplode)
	{
		Destroy();
		return;
	}
}

void CS_AmFishMissileBig::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"set_smog")
	{
		SetPeSmog(shared_from_this(), x, y, 1, 1, 90);
	}
}

void CS_AmFishMissileBig::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_AmFishMissileBig::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp > 0)
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	else
		Explode();
	return true;
}

void CS_AmFishMissileBig::Explode()
{
	attackState = true;
	cbRect.left = cbRect.right = 64;
	cbRect.top = cbRect.bottom = 50;
	gameFunc->PlaySound(L"CS_071_little_crash");
	SetCS_PeSmoke(shared_from_this(), x, y, 100);
	bExplode = true;
	ani.png = L"";
}

std::shared_ptr<Entity> CreateCS_AmFishMissileBig()
{
	return std::make_shared<CS_AmFishMissileBig>(nullptr);
}
