#include "CS_AmFishMissile.h"
#include "CS_PeSmoke.h"
#include "CS_PeBooster.h"
CS_AmFishMissile::CS_AmFishMissile(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 4;
	hp = hp_max = 1;
	//ö
	ani.sprite_index = L"am_ fishmissile";
	//
	speedDir = true;
}

void CS_AmFishMissile::Step()
{
	auto& ani_no = ani.image_index;
	if(!ani.png.length())
		ani.png = L"CS_CaveStoryMod";
	switch (act_no)
	{
	case 0:
		act_no = 1;
		switch (lr)
		{
		case 0:
			angle = 225;
			break;

		case 1:
			angle = 315;
			break;

		case 2:
			angle = 45;
			break;

		case 3:
			angle = 135;
			break;
		}
		[[fallthrough]];
	case 1:
		//  NPC λãԲ˶
		vx = 2 * cosf(angle * deg2rad);
		vy = 2 * sinf(angle * deg2rad);
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				// ָҵķ
				float dx = wplayer->x - x;
				float dy = wplayer->y - y;
				float dir_rad = atan2f(dy, dx);
				float dir_deg = dir_rad / deg2rad;
				if (dir_deg < 0)
					dir_deg += 360.0f;
				// ƽǶ
				float angle_diff = fmodf(dir_deg - angle + 360.0f, 360.0f);
				if (angle_diff > 180.0f) 
					angle_diff -= 360.0f;

				if (angle_diff > 1.0f)
					angle += 360.0f / 256.0f;// ˳ʱ΢
				else if (angle_diff < -1.0f)
					angle -= 360.0f / 256.0f; // ʱ΢
				// ȷǶ 0~360
				if (angle > 360.0f)
					angle -= 360.0f;
				if (angle < 0.0f)
					angle += 360.0f;
			}
		}
		break;
	}
	//ִ˶
	Entity::Step();
	if (++ani_wait > 2)
	{
		ani_wait = 0;
		auto pe = std::make_shared<CS_PeBooster>(4);
		pe->x = x;
		pe->y = y;
		pe->vx = 0;
		pe->vy = 0;
		pe->drawBeforeOtherEntity = false;
		gameFunc->SetEntity(shared_from_this(), pe);
	}
	ani_no = (int)((angle / 360.0f * 256.0f) + 16.0f) / 32;
	if (ani_no > 7)
		ani_no = 7;
}

void CS_AmFishMissile::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 5;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_AmFishMissile::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_051_enemy_hurt");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		Destroy();
	}
	return true;
}

std::shared_ptr<Entity> CreateCS_AmFishMissile()
{
	return std::make_shared<CS_AmFishMissile>(nullptr);
}

void SetCS_AmFishMissile(std::shared_ptr<Entity> parent, float x, float y, int direct)
{
	auto am = std::make_shared<CS_AmFishMissile>(parent);
	am->x = x;
	am->y = y;
	am->lr = direct;
	parent->gameFunc->SetEntity(parent, am);
}
