#include "CS_AmDemonFlowerSeed.h"
#include "CS_PeSmoke.h"
#include "CS_PePhoton.h"

CS_AmDemonFlowerSeed::CS_AmDemonFlowerSeed(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 4;
	hp_max = hp = 2;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_demonflowerseed";
	el.name = CS_AMDEMONFLOWERSEED_CREATENAME;
	//
	speedDir = true;
}

void CS_AmDemonFlowerSeed::Step()
{
	vy += 30 / ts;
	if (cbRect.cbLeft)
		vx = abs(vx);
	if (cbRect.cbRight)
		vx = -abs(vx);
	if (cbRect.cbTop)
		vy = abs(vy);
	if (cbRect.cbBottom)
		vy = -abs(vy);
	if (existTime > 0)
	{
		existTime--;
		if (existTime == 0)
		{
			SetCS_PePhoton(shared_from_this(), x, y);
			Destroy();
		}
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_AmDemonFlowerSeed::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 2;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_AmDemonFlowerSeed::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		Destroy();
	}
	return true;
}

std::shared_ptr<Entity> CreateCS_AmDemonFlowerSeed()
{
	return std::make_shared<CS_AmDemonFlowerSeed>(nullptr);
}

void SetCS_AmDemonFlowerSeed(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmDemonFlowerSeed>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
}
