#include "MyView.h"

void MyViewDrawFor::Init(MyView* view)
{
	this->view = view;
}

void MyViewDrawFor::DrawForYBegin(int** outY)
{
	draw_xMax = (int)(view->window_w / (view->grid_w * view->scale) + view->offX / view->grid_w + 2);
	draw_yMax = (int)(view->window_h / (view->grid_h * view->scale) + view->offY / view->grid_h + 2);
	count_h = view->count_max % view->count_w ? view->count_max / view->count_w + 1 : view->count_max / view->count_w;

	rc_draw_w = view->grid_w * view->scale;
	rc_draw_h = view->grid_h * view->scale;

	_y = (int)max(view->offY / view->grid_h, 0);
	rc_draw_y = _y * view->grid_h * view->scale - floorf(view->offY * view->scale);
	if (outY)
		*outY = &_y;
}

bool MyViewDrawFor::DrawForY()
{
	return _y < draw_yMax;
}

void MyViewDrawFor::DrawForYInc()
{
	_y++;
	rc_draw_y += rc_draw_h;
}

void MyViewDrawFor::DrawForXBegin(int** outX)
{
	_x = (int)max(view->offX / view->grid_w, 0);
	rc_draw_x = _x * view->grid_w * view->scale - floorf(view->offX * view->scale);
	if (outX)
		*outX = &_x;
}

bool MyViewDrawFor::DrawForX(MyRect* outRect)
{
	if (outRect)
		outRect->Set1(rc_draw_x, rc_draw_y, rc_draw_w, rc_draw_h);
	return  _x < draw_xMax;
}

void MyViewDrawFor::DrawForXInc()
{
	_x++;
	rc_draw_x += rc_draw_w;
}
