#include "ItemSystem.h"
#include "main.h"
#include "MiniScriptSystem.h"
#include "Pathfinding.h"
ItemSystem::~ItemSystem()
{
	//
	if (myfont12)
		TTF_CloseFont(myfont12);
	for (auto& p : fontMap_myfont12)
	{
		if (p.second.pSRV)
			p.second.pSRV->Release();
		if (p.second.pTexture)
			p.second.pTexture->Release();
	}
	fontMap_myfont12.clear();
	delete childScriptSys_player1;
	delete childScriptSys_player2;
}

void ItemSystem::Init(MyDX11Renderer* pRenderer, MyView* pView, MySDLInput* pSDLInput, GameMsgbox* pGameMsgBox,
	GameScript* pGameScript, MapSystem* pMapSystem, EntityRes* pEntityRes, GameUI* pGameUI, const void* game)
{
	this->pRenderer = pRenderer;
	this->pView = pView;
	this->pSDLInput = pSDLInput;
	this->pGameMsgBox = pGameMsgBox;
	this->pGameScript = pGameScript;
	this->pMapSystem = pMapSystem;
	this->pEntityRes = pEntityRes;
	this->pGameUI = pGameUI;
	myfont12 = pRenderer->MyLoadFont(pixelFont_size12.c_str(), pixelFont_size12_arg);
	itemList.resize(27);
	childScriptSys_player1 = new MiniScriptSystem();
	childScriptSys_player1->Init((const MyGame*)game);
	childScriptSys_player2 = new MiniScriptSystem();
	childScriptSys_player2->Init((const MyGame*)game);
}

void ItemSystem::Reset()
{
	itemRegList.clear();
	for (auto& item : itemList)
	{
		item.regID = L"null";
		item.num = 0;
		item.e.reset();
		item.locked = false;
	}
	missionRegList.clear();
	missionList.clear();
	childScriptSys_player1->Reset();
	childScriptSys_player2->Reset();
	ResetCursorPos();
	for (auto& e : itemIconEntity)
		e->Destroy();
	itemIconEntity.clear();
	miniItem.num = 0;
	miniItem.e.reset();
	for (auto& we : miniItemEntity)
		we->Destroy();
	miniItemEntity.clear();
	for (auto& we : missionIconEntity)
		we->Destroy();
	missionIconEntity.clear();
	bShow = false;
	bShowMiniItem = false;
}

bool ItemSystem::GetShow()
{
	return bShow;
}

void ItemSystem::Step()
{
	if (!bEnable)
		return;
	MyView& view = *pView;
	itemsys_x = (view.window_w - itemsys_page_count_w * view.grid_w * view.scale) / 2;
	itemsys_y = (view.window_h - itemsys_page_count_h * view.grid_h * view.scale) / 2;
	bool openInventory = false;
	auto wplayer1 = pEntityRes->GetMyChar_Player1().lock();
	auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
	if (wplayer1)
	{
		if (wplayer1->input.GetInventory())
		{
			wplayer1->inputLock.SetInventory(true);
			openInventory = true;
		}
	}
	if (wplayer2)
	{
		if (wplayer2->el.name != L"null" && !wplayer2->enableAI)
		{
			if (wplayer2->input.GetInventory())
			{
				wplayer2->inputLock.SetInventory(true);
				openInventory = true;
			}
		}
	}
	//Ʒ
	if ((openInventory && bShow) ||
		(openInventory && !bShow && !pGameScript->IsRunning()))
	{
		//12ͬʱ¼ʱл
		if (IsItemSystemFree())
		{
			bShow = !bShow;
			//رƷ
			if (!bShow)
			{
				ForceEndScript(&childScriptSys_player1->gameScript, &childScriptSys_player1->gameMsgbox);
				childScriptSys_player1->gameScript.SetW99(false);
				childScriptSys_player1->gameScript.EndEvent();
				ForceEndScript(&childScriptSys_player2->gameScript, &childScriptSys_player2->gameMsgbox);
				childScriptSys_player2->gameScript.SetW99(false);
				childScriptSys_player2->gameScript.EndEvent();
				itemCursor_x_selected_player1 = itemCursor_y_selected_player1 = -1;
				itemCursor_x_selected_player2 = itemCursor_y_selected_player2 = -1;
				skillCursor_selected_player1 = skillCursor_selected_player2 = -1;
			}
		}
	}
	//Ʒ
	if (bShow)
	{
		//Ʋ˵
		bool updatePage = PageControl();
		//Ӳ˵
		switch (pageIndex)
		{
		case 0://Ʒ
			if (updatePage)
			{
				ItemMenuUpdate(&childScriptSys_player1->gameScript, &childScriptSys_player1->gameMsgbox,
					itemCursor_x_player1, itemCursor_y_player1);
				ItemMenuUpdate(&childScriptSys_player2->gameScript, &childScriptSys_player2->gameMsgbox,
					itemCursor_x_player2, itemCursor_y_player2);
			}
			ItemMenuControl(&childScriptSys_player1->gameScript, &childScriptSys_player1->gameMsgbox,
				childScriptSys_player1->GetMyChar_Player1(), &itemCursor_x_player1, &itemCursor_y_player1, &itemCursor_x_selected_player1, &itemCursor_y_selected_player1,
				&skillCursor_player1, &skillCursor_selected_player1, &itemCursorMode_player1);
			ItemMenuScript(&childScriptSys_player1->gameScript, &childScriptSys_player1->gameMsgbox,
				itemCursor_x_player1, itemCursor_y_player1);
			SkillMenuScript(&childScriptSys_player1->gameScript, &childScriptSys_player1->gameMsgbox,
				pGameUI->GetPlayerUIData(0), skillCursor_player1);

			ItemMenuControl(&childScriptSys_player2->gameScript, &childScriptSys_player2->gameMsgbox,
				childScriptSys_player2->GetMyChar_Player2(), &itemCursor_x_player2, &itemCursor_y_player2, &itemCursor_x_selected_player2, &itemCursor_y_selected_player2,
				&skillCursor_player2, &skillCursor_selected_player2, &itemCursorMode_player2);
			ItemMenuScript(&childScriptSys_player2->gameScript, &childScriptSys_player2->gameMsgbox,
				itemCursor_x_player2, itemCursor_y_player2);
			SkillMenuScript(&childScriptSys_player2->gameScript, &childScriptSys_player2->gameMsgbox,
				pGameUI->GetPlayerUIData(1), skillCursor_player2);
			break;
		case 1://
			if (updatePage)
			{
				MissionMenuUpdate(&childScriptSys_player1->gameScript, &childScriptSys_player1->gameMsgbox,
					missionCursor_player1);
				MissionMenuUpdate(&childScriptSys_player2->gameScript, &childScriptSys_player2->gameMsgbox,
					missionCursor_player2);
			}
			MissionMenuControl(&childScriptSys_player1->gameScript, &childScriptSys_player1->gameMsgbox,
				childScriptSys_player1->GetMyChar_Player1(), &missionCursor_player1);
			MissionMenuScript(&childScriptSys_player1->gameScript, &childScriptSys_player1->gameMsgbox,
				missionCursor_player1);

			MissionMenuControl(&childScriptSys_player2->gameScript, &childScriptSys_player2->gameMsgbox,
				childScriptSys_player2->GetMyChar_Player2(), &missionCursor_player2);
			MissionMenuScript(&childScriptSys_player2->gameScript, &childScriptSys_player2->gameMsgbox,
				missionCursor_player2);
			break;
		}
		//˸
		if (cursor_flash_interval_counter > 0)
			cursor_flash_interval_counter--;
		if (cursor_flash_interval_counter == 0)
		{
			cursor_flash_interval_counter = cursor_flash_interval;
			cursor_flash = !cursor_flash;
		}
		//ӽűϵͳ
		bool twoPlayerMode = false;
		if (wplayer2 && wplayer2->el.name != L"null" && !wplayer2->enableAI)
			twoPlayerMode = true;
		if (twoPlayerMode)
		{
			//
			childScriptSys_player1->SetMode(-1, 0);
			childScriptSys_player1->Step();
			childScriptSys_player2->SetMode(1, 1);
			childScriptSys_player2->Step();
		}
		else
		{
			//ֻ1
			childScriptSys_player1->SetMode(0, 0);
			childScriptSys_player1->Step();
		}
		//Ʒͼʵ
		for (auto& item : itemList)
		{
			auto we = item.e.lock();
			if (item.num > 0 && !we)
			{
				//Ʒͼʵ
				auto& reg = itemRegList.at(item.regID);
				//ʵ
				item.e = we = GameCreateEntity(reg.iconEntityName.c_str());
				if (we)
					we->gameFunc = pEntityRes->GetGameFunc();
				if (!we->initCheck)
					we->Init(we);
				itemIconEntity.push_back(we);
			}
			else if (item.num == 0 && we)
			{
				//ɾʵ
				we->Destroy();
			}
		}
		pEntityRes->StepList(&itemIconEntity);
		//ͼʵ
		for (auto& mission : missionList)
		{
			auto we = mission.e.lock();
			if (!we)
			{
				//ͼʵ
				auto& reg = missionRegList.at(mission.regID);
				//ʵ
				mission.e = we = GameCreateEntity(reg.iconEntityName.c_str());
				if (we)
					we->gameFunc = pEntityRes->GetGameFunc();
				if (!we->initCheck)
					we->Init(we);
				missionIconEntity.push_back(we);
			}
		}
	}
	//Ʒ
	if (bShowMiniItem)
	{
		pEntityRes->StepList(&miniItemEntity);
	}
}

void ItemSystem::Draw(float deltaTime)
{
	if (!bEnable)
		return;
	//Ʒ
	if (bShow)
	{
		DrawFrame();
		//ӽűϵͳ
		childScriptSys_player1->Draw(deltaTime);
		auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
		if (wplayer2)
		{
			if (wplayer2->el.name != L"null" && !wplayer2->enableAI)
				childScriptSys_player2->Draw(deltaTime);
		}
		if (IsItemSystemFree())
			DrawPanelFreeGraph();
	}
	//Ʒ
	if (bShowMiniItem)
	{
		DrawMiniItem();
	}
}

void ItemSystem::OnResetScale(int w, int h)
{
	if (childScriptSys_player1)
		childScriptSys_player1->OnResetScale(w, h);
	if (childScriptSys_player2)
		childScriptSys_player2->OnResetScale(w, h);
}

void ItemSystem::SetEnable(bool bEnable)
{
	this->bEnable = bEnable;
	if (!bEnable)
	{
		bShow = false;
		childScriptSys_player1->gameScript.SetW99(false);
		childScriptSys_player2->gameScript.SetW99(false);
	}
}

bool ItemSystem::IsPanelFree(GameScript* gameScript)
{
	return !gameScript->GetKEY() && !gameScript->GetPRI();
}

bool ItemSystem::IsItemSystemFree()
{
	return IsPanelFree(&childScriptSys_player1->gameScript) &&
		IsPanelFree(&childScriptSys_player2->gameScript);
}

void ItemSystem::RegisterItem(const wchar_t* regID, ItemRegister itemReg)
{
	auto iter = itemRegList.find(regID);
	if (iter == itemRegList.end())
		itemRegList.insert(std::make_pair(regID, itemReg));
}

int ItemSystem::AddItem(const wchar_t* regID, int num)
{
	//ҸƷǷ
	auto iter = itemRegList.find(regID);
	if (iter == itemRegList.end())
	{
		//Ʒδע
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"Ʒ%sδע", regID);
		MessageBoxW(hwnd, err, L"Ʒʧ", MB_ICONWARNING);
	}
	ItemRegister& itemReg = iter->second;
	//ƷԵ
	if (itemReg.stackable)
	{
		//ǷӵдƷƷţ
		for (auto& item : itemList)
		{
			if (item.regID == regID)
			{
				//Ʒ
				item.num += num;
				return item.num;
			}
		}
	}
	//޷ֱƷ
	ItemData itemData;
	itemData.regID = regID;
	itemData.num = num;
	//Ѱҿλ
	for (auto& item : itemList)
	{
		if (item.num == 0)
		{
			item = itemData;
			return item.num;
		}	
	}
	return 0;
}

int ItemSystem::FindItem(const wchar_t* regID)
{
	int index = 0;
	for (auto& item : itemList)
	{
		if (item.regID == regID)
			return index;
		index++;
	}
	return -1;
}

void ItemSystem::LockItem(int itemIndex, bool bLock)
{
	if (itemIndex >= itemList.size())
		return;
	itemList[itemIndex].locked = bLock;
}

bool ItemSystem::ItemLocked(int itemIndex)
{
	if (itemIndex >= itemList.size())
		return false;
	return itemList[itemIndex].locked;
}

std::vector<ItemData>* ItemSystem::GetItemList()
{
	return &itemList;
}

void ItemSystem::RegisterMission(const wchar_t* regID, MissionRegister missionReg)
{
	auto iter = missionRegList.find(regID);
	if (iter == missionRegList.end())
		missionRegList.insert(std::make_pair(regID, missionReg));
}

void ItemSystem::AddMission(const wchar_t* regID)
{
	//ҸǷ
	auto iter = missionRegList.find(regID);
	if (iter == missionRegList.end())
	{
		//δע
		wchar_t err[MAX_PATH];
		swprintf_s(err, L"%sδע", regID);
		MessageBoxW(hwnd, err, L"ʧ", MB_ICONWARNING);
	}
	MissionRegister& missionReg = iter->second;
	//Ƿ
	auto iter2 = FindMission(regID);
	if (iter2 != missionList.end())
		return;
	//
	MissionData missionData;
	missionData.regID = regID;
	missionList.push_back(missionData);
}

void ItemSystem::DeleteMission(const wchar_t* regID)
{
	auto iter = FindMission(regID);
	if (iter == missionList.end())
		return;
	auto we = iter->e.lock();
	if (we)
		we->Destroy();
	missionList.erase(iter);
	if (missionCursor_player1 > (int)missionList.size() - 1)
		missionCursor_player1 = (int)missionList.size() - 1;
	if (missionCursor_player2 > (int)missionList.size() - 1)
		missionCursor_player2 = (int)missionList.size() - 1;
}

void ItemSystem::DeleteAllMission()
{
	for (auto& p : missionList)
	{
		auto we = p.e.lock();
		if (we)
			we->Destroy();
	}
	missionList.clear();
	missionCursor_player1 = 0;
	missionCursor_player2 = 0;
}

void ItemSystem::ReplaceMission(const wchar_t* regID_src, const wchar_t* regID_dst)
{
	auto iter = FindMission(regID_src);
	if (iter == missionList.end())
		return;
	auto we = iter->e.lock();
	if (we)
		we->Destroy();
	iter->regID = regID_dst;
}

std::list<MissionData>::iterator ItemSystem::FindMission(const wchar_t* regID)
{
	for (auto iter = missionList.begin(); iter != missionList.end(); iter++)
		if (iter->regID == regID)
			return iter;
	return missionList.end();
}

std::list<MissionData>* ItemSystem::GetMissionList()
{
	return &missionList;
}

void ItemSystem::Controll()
{
	if (childScriptSys_player1)
		childScriptSys_player1->Controll();
	if (pEntityRes)
	{
		auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
		if (wplayer2)
		{
			if (wplayer2->el.name != L"null" && !wplayer2->enableAI)
			{
				if (childScriptSys_player2)
					childScriptSys_player2->Controll();
			}
		}
	}
}

void ItemSystem::SetShowMiniItem(bool bShowMiniItem, const wchar_t* regID, int num)
{
	this->bShowMiniItem = bShowMiniItem;
	if (bShowMiniItem)
	{
		miniItem.regID = regID;
		miniItem.num = num;
		//ǸƷʵ
		auto iter = itemRegList.find(regID);
		if (iter == itemRegList.end())
		{
			//Ʒδע
			wchar_t err[MAX_PATH];
			swprintf_s(err, L"Ʒ%sδע", regID);
			MessageBoxW(hwnd, err, L"չʾƷʧ", MB_ICONWARNING);
		}
		ItemRegister& itemReg = iter->second;
		//ʵ
		auto we = GameCreateEntity(itemReg.iconEntityName.c_str());
		miniItem.e = we;
		if (we)
			we->gameFunc = pEntityRes->GetGameFunc();
		if (!we->initCheck)
			we->Init(we);
		miniItemEntity.push_back(we);
	}
	else
	{
		auto we = miniItem.e.lock();
		//
		if (we)
			we->Destroy();
		miniItem.num = 0;
	}
}

void ItemSystem::LockAllPlayerJump()
{
	if (childScriptSys_player1)
		childScriptSys_player1->LockAllPlayerJump();
	if (childScriptSys_player2)
		childScriptSys_player2->LockAllPlayerJump();
}

bool ItemSystem::IsEnableMapSystem()
{
	int index = FindItem(L"MapSystem");
	if (index == -1)
		return false;
	auto& item = itemList[index];
	return item.num > 0;
}

void ItemSystem::ReloadLanguage()
{
	if (childScriptSys_player1)
		childScriptSys_player1->ReloadGameMapScript();
	if (childScriptSys_player2)
		childScriptSys_player2->ReloadGameMapScript();
}

void ItemSystem::DrawFrame()
{
	MyView& view = *pView;
	std::wstring style = pGameMsgBox->GetMsgBoxStyle();
	if (style.length() == 0)
		style = L"default";
	auto& tas = *GetMsgboxTexture(style.c_str());
	float src_x, src_y;
	float dst_x, dst_y, dst_w, dst_h;
	const float msgbox_grid_w = 16;
	const float msgbox_grid_h = 16;
	dst_w = view.grid_w * view.scale;
	dst_h = view.grid_h * view.scale;

	MyRect src, dst;
	pRenderer->SetTPenDraw(tas.pSRV);
	//
	for (int Y = 2; Y < itemsys_page_count_h - 6; Y++)
	{
		for (int X = 0; X < itemsys_page_count_w; X++)
		{
			if (X == 0)
				src_x = 0;
			else if (X == itemsys_page_count_w - 1)
				src_x = msgbox_grid_w * 2;
			else
				src_x = msgbox_grid_w;
			if (Y == 2)
				src_y = 0;
			else if (Y == itemsys_page_count_h - 7)
				src_y = msgbox_grid_h * 2;
			else
				src_y = msgbox_grid_h;
			src_x += 48;
			src_y += 48;
			dst_x = itemsys_x + X * view.grid_w * view.scale;
			dst_y = itemsys_y + Y * view.grid_h * view.scale;
			src.Set1(src_x, src_y, msgbox_grid_w, msgbox_grid_h);
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
	}
	//Ʋ˵
	for (int i = 0; i < 2; i++)
	{
		if (i == 0)
		{
			src.Set1(0, 240 + (i == pageIndex ? 0 : 16.0f), 96, 16);
		}
		else
		{
			src.Set1(0, 272 + (i == pageIndex ? 0 : 16.0f), 96, 16);
		}
		dst_x = itemsys_x + (i * 10 + 2) * view.grid_w * view.scale;
		dst_y = itemsys_y + 8 * view.scale;
		dst_w = 96 * view.scale;
		dst_h = msgbox_grid_h * view.scale;
		dst.Set1(dst_x, dst_y, dst_w, dst_h);
		pRenderer->AddRenderCopy(&src, &dst);
	}
	//MsgboxTexture
	switch (pageIndex)
	{
	case 0://Ʒ
		DrawAddItemPage();
		break;
	case 1://
		DrawAddMissionPage();
		break;
	}
	pRenderer->DrawRenderCopy();
	///ItemTexture
	switch (pageIndex)
	{
	case 0://Ʒ
		DrawItem();
		//ƹ
		pRenderer->SetTPenDraw(tas.pSRV);
		DrawAddCursor();
		pRenderer->DrawRenderCopy();
		break;
	case 1://
		DrawMission();
		break;
	}
}

void ItemSystem::DrawAddItemPage()
{
	MyView& view = *pView;
	MyRect src, dst;
	float dst_x, dst_y, dst_w, dst_h;
	float offy = 100;
	//Ʒ
	src.Set1(32, 208, 32, 32);
	for (int y = 0; y < 3; y++)
	{
		for (int x = 0; x < 9; x++)
		{
			dst_x = itemsys_x + (16 + x * 32) * view.scale;
			dst_y = itemsys_y + (48 + y * 32 + offy) * view.scale;
			dst_w = 32 * view.scale;
			dst_h = 32 * view.scale;
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
	}
}

void ItemSystem::DrawAddMissionPage()
{
	MyView& view = *pView;
	MyRect src, dst;
	float dst_x, dst_y, dst_w, dst_h;
	src.Set1(80, 32, 16, 16);
	for (int y = 0; y < missionList.size(); y++)
	{
		for (int x = 0; x < 17; x++)
		{
			dst_x = itemsys_x + (24 + x * 16) * view.scale;
			dst_y = itemsys_y + (60 + y * 24) * view.scale;
			dst_w = 16 * view.scale;
			dst_h = 16 * view.scale;
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
	}
	//
	if (missionList.empty())
		return;

	float missionCursorFlashSrcDx = cursor_flash ? 0 : 16.0f;
	src.Set1(176 + missionCursorFlashSrcDx, 64, 16, 16);
	dst_x = itemsys_x + 8 * view.scale;
	dst_y = itemsys_y + (50 + missionCursor_player1 * 24) * view.scale;
	dst_w = 16 * view.scale;
	dst_h = 16 * view.scale;
	dst.Set1(dst_x, dst_y, dst_w, dst_h);
	pRenderer->AddRenderCopy(&src, &dst);
	//2
	auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
	if (wplayer2)
	{
		if (wplayer2->el.name != L"null" && !wplayer2->enableAI)
		{
			src.Set1(176 + missionCursorFlashSrcDx, 80, 16, 16);
			dst_x = itemsys_x + 296 * view.scale;
			dst_y = itemsys_y + (50 + missionCursor_player2 * 24) * view.scale;
			dst_w = 16 * view.scale;
			dst_h = 16 * view.scale;
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
	}
}

bool ItemSystem::PageControl()
{
	if (!IsItemSystemFree())
		return false;
	auto wplayer1 = pEntityRes->GetMyChar_Player1().lock();
	auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
	bool bPagePrev = false;
	bool bPageNext = false;
	if (wplayer1)
	{
		if (wplayer1->input.GetPagePrev())
		{
			wplayer1->inputLock.SetPagePrev(true);
			bPagePrev = true;
		}
		else if (wplayer1->input.GetPageNext())
		{
			wplayer1->inputLock.SetPageNext(true);
			bPageNext = true;
		}
	}
	if (wplayer2)
	{
		if (wplayer2->input.GetPagePrev())
		{
			wplayer2->inputLock.SetPagePrev(true);
			bPagePrev = true;
		}
		else if (wplayer2->input.GetPageNext())
		{
			wplayer2->inputLock.SetPageNext(true);
			bPageNext = true;
		}
	}

	if (bPagePrev)
	{
		if (pageIndex == 0)
			pageIndex = 1;
		else
			pageIndex--;
		ForceEndScript(&childScriptSys_player1->gameScript, &childScriptSys_player1->gameMsgbox);
		ForceEndScript(&childScriptSys_player2->gameScript, &childScriptSys_player2->gameMsgbox);
		return true;
	}
	else if (bPageNext)
	{
		if (pageIndex == 1)
			pageIndex = 0;
		else
			pageIndex++;
		ForceEndScript(&childScriptSys_player1->gameScript, &childScriptSys_player1->gameMsgbox);
		ForceEndScript(&childScriptSys_player2->gameScript, &childScriptSys_player2->gameMsgbox);
		return true;
	}
	return false;
}

void ItemSystem::ForceEndScript(GameScript* gameScript, GameMsgbox* gameMsgBox)
{
	int i = 60;
	while (gameScript->IsRunning())
	{
		gameScript->SetWait(0);
		gameScript->SetWAS(false);
		gameScript->SetNOD(false);
		gameMsgBox->TUR(true);
		gameMsgBox->CLR();
		gameScript->Step();
		gameScript->Step();
		//ֹס
		if (i > 0)
			i--;
		if (i == 0)
			break;
	}
	gameMsgBox->CLO();
}

int ItemSystem::SkillCursorToItemCursorX(int playerIndex) const
{
	if (playerIndex == 0)
	{
		//1±
		switch (skillCursor_player1)
		{
		case 0:
			return 0;
		case 1:
		case 2:
			return 1;
		case 3:
			return 2;
		case 4:
		case 5:
			return 3;
		}
	}
	else
	{
		//2±
		switch (skillCursor_player2)
		{
		case 0:
		case 1:
			return 5;
		case 2:
			return 6;
		case 3:
		case 4:
			return 7;
		case 5:
			return 8;
		}
	}
	return 0;
}

int ItemSystem::ItemCursorXToSkillCursor(int playerIndex) const
{
	if (playerIndex == 0)
	{
		//1±
		switch (itemCursor_x_player1)
		{
		case 0:
			return 0;
		case 1:
			return 1;
		case 2:
			return 3;
		case 3:
			return 4;
		case 4:
		case 5:
		case 6:
		case 7:
		case 8:
			return 5;
		}
	}
	else
	{
		//2±
		switch (itemCursor_x_player2)
		{
		case 0:
		case 1:
		case 2:
		case 3:
		case 4:
			return 0;
		case 5:
			return 1;
		case 6:
			return 2;
		case 7:
			return 4;
		case 8:
			return 5;
		}
	}
	return 0;
}

void ItemSystem::DrawItem()
{
	MyView& view = *pView;
	//仯
	DrawPanel_Player1(0 + 8, 0 - 12);
	auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
	if (wplayer2 && wplayer2->el.name != L"null")
		DrawPanel_Player2(240 + 8, 0 - 12);
	//ϲ
	{
		float offx = 0 + 8;
		float offy = 0 - 12;
		//1
		auto wplayer = pEntityRes->GetMyChar_Player1().lock();
		if (wplayer)
			DrawAddEntity(wplayer, offx, offy);
		//1ܰ
		float drawSkillKeyIndex = 0;
		for (int i = 14; i < 20; i++)
		{
			auto we = pGameUI->GetPlayerKey(0)[i].lock();
			if (we)
			{
				we->hide = false;
				DrawAddEntity(we, drawSkillKeyIndex + offx - 5, offy + 28);
			}
			drawSkillKeyIndex += 21;
		}
		//2
		offx = 240 + 8;
		offy = 0 - 12;
		if (wplayer2 && wplayer2->el.name != L"null")
		{
			//
			DrawAddEntity(wplayer2, offx, offy);
			//Ƽܰ
			if (!wplayer2->enableAI)
			{
				float drawSkillKeyIndex = 0;
				for (int i = 14; i < 20; i++)
				{
					auto we = pGameUI->GetPlayerKey(1)[i].lock();
					if (we)
					{
						we->hide = false;
						DrawAddEntity(we, drawSkillKeyIndex + offx - 99, offy + 28);
					}
					drawSkillKeyIndex += 21;
				}
			}
		}
		//Ʒ
		DrawAddItemIconEntity();
		pEntityRes->DrawEntity();
	}
	MyRect src, dst;
	//Ʒ
	char numbuff[16];
	int len;
	int begin;
	int time;
	std::wstring style = pGameMsgBox->GetMsgBoxStyle();
	if (style.length() == 0)
		style = L"default";
	auto& msgBoxTas = *GetMsgboxTexture(style.c_str());
	pRenderer->SetTPenDraw(msgBoxTas.pSRV);
	for (int y = 0; y < 3; y++)
	{
		for (int x = 0; x < 9; x++)
		{
			auto& item = itemList[y * 9 + x];
			if (item.num <= 0)
				continue;
			auto iter = itemRegList.find(item.regID);
			if (iter == itemRegList.end())
				continue;
			auto& itemReg = iter->second;
			if (itemReg.stackable)
			{
				//Ʒ
				sprintf_s(numbuff, "%d", item.num);
				len = (int)strlen(numbuff);
				begin = 32 - len * 6;
				time = 0;
				for (int i = 0; i < len; i++)
				{
					src.Set1((numbuff[i] - '0') * 5.0f,
						160, 5, 7);
					dst.Set1(itemsys_x + (15 + x * 32 + time + begin) * view.scale,
						itemsys_y + (48 + 100 + y * 32 + 23) * view.scale,
						5 * view.scale, 7 * view.scale);
					pRenderer->AddRenderCopy(&src, &dst);
					time += 6;
				}
			}
		}
	}
	pRenderer->DrawRenderCopy();
}

void ItemSystem::DrawAddCursor()
{
	MyView& view = *pView;
	MyRect src, dst;
	float dst_x, dst_y, dst_w, dst_h;
	float offy = 100;
	//Ʒ
	float itemCursorFlashSrcDx = cursor_flash ? 0 : 32.0f;
	float skillCursorFlashSrcDx = cursor_flash ? 0 : 20.0f;
	auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
	//1
	if (itemCursorMode_player1 == 0)
	{
		//1Ʒ
		if ((itemCursor_x_player1 == itemCursor_x_player2 && itemCursor_y_player1 == itemCursor_y_player2) &&
			wplayer2 && wplayer2->el.name != L"null" && !wplayer2->enableAI)
		{
			src.Set1(96.0f + itemCursorFlashSrcDx, 0, 16, 32);
			dst_x = itemsys_x + (16 + itemCursor_x_player1 * 32) * view.scale;
			dst_y = itemsys_y + (48 + itemCursor_y_player1 * 32 + offy) * view.scale;
			dst_w = 16 * view.scale;
			dst_h = 32 * view.scale;
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
		else
		{
			src.Set1(96.0f + itemCursorFlashSrcDx, 0, 32, 32);
			dst_x = itemsys_x + (16 + itemCursor_x_player1 * 32) * view.scale;
			dst_y = itemsys_y + (48 + itemCursor_y_player1 * 32 + offy) * view.scale;
			dst_w = 32 * view.scale;
			dst_h = 32 * view.scale;
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
		//Ʒѡ
		if (itemCursor_x_selected_player1 >= 0 && itemCursor_y_selected_player1 >= 0)
		{
			src.Set1(160 + itemCursorFlashSrcDx, 0, 32, 32);
			dst_x = itemsys_x + (16 + itemCursor_x_selected_player1 * 32) * view.scale;
			dst_y = itemsys_y + (48 + itemCursor_y_selected_player1 * 32 + offy) * view.scale;
			dst_w = 32 * view.scale;
			dst_h = 32 * view.scale;
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
	}
	if (itemCursorMode_player1 == 1)
	{
		//1
		src.Set1(96.0f + skillCursorFlashSrcDx, 64, 20, 20);
		dst_x = itemsys_x + (24 + skillCursor_player1 * 21) * view.scale;
		dst_y = itemsys_y + (6 + offy) * view.scale;
		dst_w = 20 * view.scale;
		dst_h = 20 * view.scale;
		dst.Set1(dst_x, dst_y, dst_w, dst_h);
		pRenderer->AddRenderCopy(&src, &dst);
		//1ѡ
		if (skillCursor_selected_player1 >= 0)
		{
			src.Set1(96.0f + skillCursorFlashSrcDx + 40, 64, 20, 20);
			dst_x = itemsys_x + (24 + skillCursor_selected_player1 * 21) * view.scale;
			dst_y = itemsys_y + (6 + offy) * view.scale;
			dst_w = 20 * view.scale;
			dst_h = 20 * view.scale;
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
	}
	if (wplayer2 && wplayer2->el.name != L"null" && !wplayer2->enableAI)
	{
		//2
		if (itemCursorMode_player2 == 0)
		{
			//2Ʒ
			if (itemCursor_x_player1 == itemCursor_x_player2 && itemCursor_y_player1 == itemCursor_y_player2)
			{
				src.Set1(96.0f + itemCursorFlashSrcDx + 16.0f, 32, 16, 32);
				dst_x = itemsys_x + (32 + itemCursor_x_player2 * 32) * view.scale;
				dst_y = itemsys_y + (48 + itemCursor_y_player2 * 32 + offy) * view.scale;
				dst_w = 16 * view.scale;
				dst_h = 32 * view.scale;
				dst.Set1(dst_x, dst_y, dst_w, dst_h);
				pRenderer->AddRenderCopy(&src, &dst);
			}
			else
			{
				src.Set1(96.0f + itemCursorFlashSrcDx, 32, 32, 32);
				dst_x = itemsys_x + (16 + itemCursor_x_player2 * 32) * view.scale;
				dst_y = itemsys_y + (48 + itemCursor_y_player2 * 32 + offy) * view.scale;
				dst_w = 32 * view.scale;
				dst_h = 32 * view.scale;
				dst.Set1(dst_x, dst_y, dst_w, dst_h);
				pRenderer->AddRenderCopy(&src, &dst);
			}
			//Ʒѡ
			if (itemCursor_x_selected_player2 >= 0 && itemCursor_y_selected_player2 >= 0)
			{
				src.Set1(160 + itemCursorFlashSrcDx, 32, 32, 32);
				dst_x = itemsys_x + (16 + itemCursor_x_selected_player2 * 32) * view.scale;
				dst_y = itemsys_y + (48 + itemCursor_y_selected_player2 * 32 + offy) * view.scale;
				dst_w = 32 * view.scale;
				dst_h = 32 * view.scale;
				dst.Set1(dst_x, dst_y, dst_w, dst_h);
				pRenderer->AddRenderCopy(&src, &dst);
			}
		}
		else if (itemCursorMode_player2 == 1)
		{
			//2
			src.Set1(96.0f + skillCursorFlashSrcDx, 84, 20, 20);
			dst_x = itemsys_x + (170 + skillCursor_player2 * 21) * view.scale;
			dst_y = itemsys_y + (6 + offy) * view.scale;
			dst_w = 20 * view.scale;
			dst_h = 20 * view.scale;
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
			//1ѡ
			if (skillCursor_selected_player2 >= 0)
			{
				src.Set1(96.0f + skillCursorFlashSrcDx + 40, 84, 20, 20);
				dst_x = itemsys_x + (170 + skillCursor_selected_player2 * 21) * view.scale;
				dst_y = itemsys_y + (6 + offy) * view.scale;
				dst_w = 20 * view.scale;
				dst_h = 20 * view.scale;
				dst.Set1(dst_x, dst_y, dst_w, dst_h);
				pRenderer->AddRenderCopy(&src, &dst);
			}
		}
	}
}

void ItemSystem::ItemMenuControl(GameScript* gameScript, GameMsgbox* gameMsgBox, std::weak_ptr<Entity> player, 
	int* pCursorX, int* pCursorY, int* pCursorX_selected, int* pCursorY_selected, int* pSkillCursor, int* pSkillCursor_selected, int* pItemCursorMode)
{
	if (!IsPanelFree(gameScript))
		return;
	auto& cursorX = *pCursorX;
	auto& cursorY = *pCursorY;
	auto& cursorX_selected = *pCursorX_selected;
	auto& cursorY_selected = *pCursorY_selected;
	auto& skillCursor = *pSkillCursor;
	auto& skillCursor_selected = *pSkillCursor_selected;
	auto& itemCursorMode = *pItemCursorMode;
	//Ʋ˵
	bool opLeft = false;
	bool opRight = false;
	bool opUp = false;
	bool opDown = false;
	bool opOk = false;
	bool opCancel = false;
	auto wplayer = player.lock();
	if (wplayer)
	{
		if (wplayer->input.GetLeft())
		{
			wplayer->inputLock.SetLeft(true);
			opLeft = true;
		}
		else if (wplayer->input.GetRight())
		{
			wplayer->inputLock.SetRight(true);
			opRight = true;
		}
		if (wplayer->input.GetUp())
		{
			wplayer->inputLock.SetUp(true);
			opUp = true;
		}
		else if (wplayer->input.GetDown())
		{
			wplayer->inputLock.SetDown(true);
			opDown = true;
		}
		if (!gameScript->IsRunning() && wplayer->input.GetOk())
		{
			wplayer->inputLock.SetOk(true);
			opOk = true;
		}
		if (wplayer->input.GetCancel())
		{
			wplayer->inputLock.SetCancel(true);
			opCancel = true;
		}
	}
	//Ʒ
	if (itemCursorMode == 0)
	{
		//
		if (opLeft)
		{
			if (cursorX == 0)
				cursorX = 8;
			else
				cursorX--;
			ItemMenuUpdate(gameScript, gameMsgBox, cursorX, cursorY);
		}
		//
		else if (opRight)
		{
			if (cursorX == 8)
				cursorX = 0;
			else
				cursorX++;
			ItemMenuUpdate(gameScript, gameMsgBox, cursorX, cursorY);
		}
		//
		if (opUp)
		{
			if (cursorY == 0)
			{
				itemCursorMode = 1;//л˵
				skillCursor = ItemCursorXToSkillCursor(pCursorX_selected == &itemCursor_x_selected_player1 ? 0 : 1);
				cursorX = cursorY = cursorX_selected = cursorY_selected -1;
				SkillMenuUpdate(gameScript, gameMsgBox,
					pGameUI->GetPlayerUIData(pCursorX_selected == &itemCursor_x_selected_player1 ? 0 : 1), skillCursor);
			}	
			else
			{
				cursorY--;
				ItemMenuUpdate(gameScript, gameMsgBox, cursorX, cursorY);
			}
		}
		//
		else if (opDown)
		{
			if (cursorY == 2)
			{
				itemCursorMode = 1;//л˵
				skillCursor = ItemCursorXToSkillCursor(pCursorX_selected == &itemCursor_x_selected_player1 ? 0 : 1);
				cursorX = cursorY = cursorX_selected = cursorY_selected - 1;
				SkillMenuUpdate(gameScript, gameMsgBox,
					pGameUI->GetPlayerUIData(pCursorX_selected == &itemCursor_x_selected_player1 ? 0 : 1), skillCursor);
			}	
			else
			{
				cursorY++;
				ItemMenuUpdate(gameScript, gameMsgBox, cursorX, cursorY);
			}
		}
		//鿴Ʒ
		if (opOk)
		{
			ItemMenuUpdate(gameScript, gameMsgBox, cursorX, cursorY, true);
		}
		//Ʒλ
		if (opCancel)
		{
			bool bExec = false;
			auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
			if (wplayer2 && wplayer2->el.name != L"null" && !wplayer2->enableAI)
			{
				//1
				if (pCursorX_selected == &itemCursor_x_selected_player1)
				{
					//ѡλ2Ĺ겻
					if (!(cursorX == itemCursor_x_player2 &&
						cursorY == itemCursor_y_player2) &&
						!(cursorX == itemCursor_x_selected_player2 &&
							cursorY == itemCursor_y_selected_player2) &&
						!(cursorX_selected == itemCursor_x_player2 &&
							cursorY_selected == itemCursor_y_player2))
						bExec = true;
				}
				//2
				else if (pCursorX_selected == &itemCursor_x_selected_player2)
				{
					//ѡλ1Ĺ겻
					if (!(cursorX == itemCursor_x_player1 &&
						cursorY == itemCursor_y_player1) &&
						!(cursorX == itemCursor_x_selected_player1 &&
							cursorY == itemCursor_y_selected_player1) &&
						!(cursorX_selected == itemCursor_x_player1 &&
							cursorY_selected == itemCursor_y_player1))
						bExec = true;
				}
			}
			else
			{
				bExec = true;
			}
			if (bExec)
			{
				if (cursorX_selected >= 0 && cursorY_selected >= 0)
				{
					//Ʒλ
					int srcIndex = cursorY_selected * 9 + cursorX_selected;
					int dstIndex = cursorY * 9 + cursorX;
					ItemData tempItem = itemList[srcIndex];
					itemList[srcIndex] = itemList[dstIndex];
					itemList[dstIndex] = tempItem;
					cursorX_selected = cursorY_selected = -1;
					ItemMenuUpdate(gameScript, gameMsgBox, cursorX, cursorY);
					PlaySound(L"YNJSelect");
				}
				else
				{
					//ѡƷλ
					cursorX_selected = cursorX;
					cursorY_selected = cursorY;
				}
			}
		}
	}
	//
	else
	{
		//
		if (opLeft)
		{
			if (skillCursor == 0)
				skillCursor = 5;
			else
				skillCursor--;
			SkillMenuUpdate(gameScript, gameMsgBox,
				pGameUI->GetPlayerUIData(pCursorX_selected == &itemCursor_x_selected_player1 ? 0 : 1), skillCursor);
		}
		//
		else if (opRight)
		{
			if (skillCursor == 5)
				skillCursor = 0;
			else
				skillCursor++;
			SkillMenuUpdate(gameScript, gameMsgBox,
				pGameUI->GetPlayerUIData(pCursorX_selected == &itemCursor_x_selected_player1 ? 0 : 1), skillCursor);
		}
		//
		if (opUp)
		{
			itemCursorMode = 0;//лƷ
			//·λ
			cursorY = 2;
			cursorX = SkillCursorToItemCursorX(pCursorX_selected == &itemCursor_x_selected_player1 ? 0 : 1);
			skillCursor = skillCursor_selected = -1;
			ItemMenuUpdate(gameScript, gameMsgBox, cursorX, cursorY);
		}
		//
		else if (opDown)
		{
			itemCursorMode = 0;//лƷ
			cursorY = 0;
			cursorX = SkillCursorToItemCursorX(pCursorX_selected == &itemCursor_x_selected_player1 ? 0 : 1);
			skillCursor = skillCursor_selected = -1;
			ItemMenuUpdate(gameScript, gameMsgBox, cursorX, cursorY);
		}
		//鿴
		if (opOk)
		{
			SkillMenuUpdate(gameScript, gameMsgBox,
				pGameUI->GetPlayerUIData(pCursorX_selected == &itemCursor_x_selected_player1 ? 0 : 1), skillCursor, true);
		}
		//λ
		if (opCancel)
		{
			if (skillCursor_selected >= 0)
			{
				//λ
				if (pCursorX_selected == &itemCursor_x_selected_player1)
				{
					//1
					auto ui = pGameUI->GetPlayerUIData(0);
					ui->SwapOp = true;
					ui->SwapSrc = skillCursor;
					ui->SwapDst = skillCursor_selected;
					auto wplayer1 = pEntityRes->GetMyChar_Player1().lock();
					if (wplayer1)
						wplayer1->ImmUpdate();
				}
				else
				{
					//2
					auto ui = pGameUI->GetPlayerUIData(1);
					ui->SwapOp = true;
					ui->SwapSrc = skillCursor;
					ui->SwapDst = skillCursor_selected;
					auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
					if (wplayer2)
						wplayer2->ImmUpdate();
				}
				skillCursor_selected = -1;
				SkillMenuUpdate(gameScript, gameMsgBox,
					pGameUI->GetPlayerUIData(pCursorX_selected == &itemCursor_x_selected_player1 ? 0 : 1), skillCursor);
				PlaySound(L"YNJSelect");
			}
			else
			{
				//ѡλ
				skillCursor_selected = skillCursor;
			}
		}
	}
}

void ItemSystem::ItemMenuUpdate(GameScript* gameScript, GameMsgbox* gameMsgBox, int cursorX, int cursorY, bool bCheck)
{
	ForceEndScript(gameScript, gameMsgBox);
	int index = cursorY * 9 + cursorX;
	if (index < itemList.size() && itemList[index].num > 0)
	{
		gameScript->EndEvent();
		gameMsgBox->CLR();
		auto& item = itemList[index];
		auto& itemReg = itemRegList.at(item.regID);
		gameScript->SetCheckItemIndex(index);
		if (bCheck)
			gameScript->StartEvent(itemReg.checkFName.c_str(), L"tBoot");
		else
			gameScript->StartEvent(itemReg.fName.c_str(), L"tBoot");
	}
	else
	{
		//ûѡƷ
		ForceEndScript(gameScript, gameMsgBox);
		gameMsgBox->CLO();
	}
}

void ItemSystem::ItemMenuScript(GameScript* gameScript, GameMsgbox* gameMsgBox, int cursorX, int cursorY)
{
	if (gameScript->IsRunning() || gameScript->GetW99())
		return;
	//Ʒ
	ItemMenuUpdate(gameScript, gameMsgBox, cursorX, cursorY);
}

void ItemSystem::SkillMenuUpdate(GameScript* gameScript, GameMsgbox* gameMsgBox, PlayerUIData* ui, int skillCursor, bool bCheck)
{
	ForceEndScript(gameScript, gameMsgBox);
	int index = skillCursor;
	if (index >= 0 && index < 6 && ui->SkillName[index].length() > 0)
	{
		gameScript->EndEvent();
		gameMsgBox->CLR();
		if (bCheck)
			gameScript->StartEvent(ui->SkillCheckName[index].c_str(), L"tBoot");
		else
			gameScript->StartEvent(ui->SkillName[index].c_str(), L"tBoot");
	}
	else
	{
		//ûѡм ûм˵
		ForceEndScript(gameScript, gameMsgBox);
		gameMsgBox->CLO();
	}
}

void ItemSystem::SkillMenuScript(GameScript* gameScript, GameMsgbox* gameMsgBox, PlayerUIData* ui, int skillCursor)
{
	if (gameScript->IsRunning() || gameScript->GetW99())
		return;
	//жӦ
	SkillMenuUpdate(gameScript, gameMsgBox, ui, skillCursor);
}

void ItemSystem::ResetCursorPos()
{
	itemCursor_x_player1 = 0;
	itemCursor_y_player1 = 0;
	itemCursor_x_selected_player1 = -1;
	itemCursor_y_selected_player1 = -1;
	itemCursor_x_player2 = 0;
	itemCursor_y_player2 = 0;
	itemCursor_x_selected_player2 = -1;
	itemCursor_y_selected_player2 = -1;
	skillCursor_player1 = -1;
	skillCursor_selected_player1 = -1;
	skillCursor_player2 = -1;
	skillCursor_selected_player2 = -1;
	itemCursorMode_player1 = 0;
	itemCursorMode_player2 = 0;
}

void ItemSystem::DrawPanelFreeGraph()
{
	MyView& view = *pView;
	MyRect src, dst;
	//1˵
	//һҳ
	auto we = pGameUI->GetPlayerKey(0)[11].lock();
	we->hide = false;
	we->ani.hideLayerList.clear();
	DrawAddEntity(we, -52, -4);
	//һҳ
	we = pGameUI->GetPlayerKey(0)[12].lock();
	we->hide = false;
	we->ani.hideLayerList.clear();
	DrawAddEntity(we, 308, -4);
	//
	we = pGameUI->GetPlayerKey(0)[9].lock();
	we->hide = false;
	we->ani.hideLayerList.clear();
	DrawAddEntity2(we, view.window_w / view.scale - 36, 12);
	//2˵
	auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
	if (wplayer2 && wplayer2->el.name != L"null" && !wplayer2->enableAI)
	{
		we = pGameUI->GetPlayerKey(1)[11].lock();
		we->hide = false;
		we->ani.hideLayerList.clear();
		DrawAddEntity(we, -52, 24);
		//һҳ
		we = pGameUI->GetPlayerKey(1)[12].lock();
		we->hide = false;
		we->ani.hideLayerList.clear();
		DrawAddEntity(we, 308, 24);
		//
		we = pGameUI->GetPlayerKey(1)[9].lock();
		we->hide = false;
		we->ani.hideLayerList.clear();
		DrawAddEntity2(we, view.window_w / view.scale - 12, 34);
	}
	pEntityRes->DrawEntity();
	//ͼ
	std::wstring style = pGameMsgBox->GetMsgBoxStyle();
	if (style.length() == 0)
		style = L"default";
	auto& tas = *GetMsgboxTexture(style.c_str());
	pRenderer->SetTPenDraw(tas.pSRV);
	//Ʒҳͷ
	src.Set1(48, 32, 16, 16);
	dst.Set1(itemsys_x + (-2 * 16 - (cursor_flash ? 1 : -1)) * view.scale,
		itemsys_y + (3 * 16) * view.scale,
		16 * view.scale,
		16 * view.scale);
	pRenderer->AddRenderCopy(&src, &dst);
	src.Set1(64, 32, 16, 16);
	dst.Set1(itemsys_x + (21 * 16 + (cursor_flash ? 1 : -1)) * view.scale,
		itemsys_y + (3 * 16) * view.scale,
		16 * view.scale,
		16 * view.scale);
	pRenderer->AddRenderCopy(&src, &dst);
	//Ʒؼͷ
	src.Set1(48, 0, 16, 16);
	dst.Set1(view.window_w - 20 * view.scale,
		4 * view.scale,
		16 * view.scale,
		16 * view.scale);
	pRenderer->AddRenderCopy(&src, &dst);
	pRenderer->DrawRenderCopy();
}

void ItemSystem::DrawMission()
{
	MyView& view = *pView;
	int index = 0;
	for (auto& missionData : missionList)
	{
		MissionRegister& reg = missionRegList.at(missionData.regID);
		float nextX = itemsys_x + 48 * view.scale;
		float nextY = itemsys_y + (50 + index * 24) * view.scale;
		pRenderer->DrawText_Unicode(&fontMap_myfont12, myfont12, reg.name.c_str(), nextX, &nextX, &nextY, RGBA(0xff, 0xff, 0xff, 0xff), view.scale, true);
		index++;
	}
	//ͼʵ
	DrawAddMissionIconEntity();
	pEntityRes->DrawEntity();
}

void ItemSystem::MissionMenuControl(GameScript* gameScript, GameMsgbox* gameMsgBox, std::weak_ptr<Entity> player, int* pMissionCursor)
{
	if (!IsPanelFree(&childScriptSys_player1->gameScript))
		return;
	auto& cursorIndex = *pMissionCursor;
	if (missionList.empty())
		cursorIndex = 0;
	//˵
	bool opLeft = false;
	bool opRight = false;
	bool opUp = false;
	bool opDown = false;
	bool opOk = false;
	bool opCancel = false;
	auto wplayer = player.lock();
	if (wplayer)
	{
		if (wplayer->input.GetLeft())
		{
			wplayer->inputLock.SetLeft(true);
			opLeft = true;
		}
		else if (wplayer->input.GetRight())
		{
			wplayer->inputLock.SetRight(true);
			opRight = true;
		}
		if (wplayer->input.GetUp())
		{
			wplayer->inputLock.SetUp(true);
			opUp = true;
		}
		else if (wplayer->input.GetDown())
		{
			wplayer->inputLock.SetDown(true);
			opDown = true;
		}
		if (!gameScript->IsRunning() && wplayer->input.GetOk())
		{
			wplayer->inputLock.SetOk(true);
			opOk = true;
		}
		if (wplayer->input.GetCancel())
		{
			wplayer->inputLock.SetCancel(true);
			opCancel = true;
		}
	}
	//
	if (opUp)
	{
		if (cursorIndex == 0)
			cursorIndex = (int)missionList.size() - 1;
		else
			cursorIndex--;
		MissionMenuUpdate(gameScript, gameMsgBox, cursorIndex);
	}
	//
	else if (opDown)
	{
		if (cursorIndex == (int)missionList.size() - 1)
			cursorIndex = 0;
		else
			cursorIndex++;
		MissionMenuUpdate(gameScript, gameMsgBox, cursorIndex);
	}
	//鿴
	if (opOk)
	{
		MissionMenuUpdate(gameScript, gameMsgBox, cursorIndex, true);
	}
}

void ItemSystem::MissionMenuUpdate(GameScript* gameScript, GameMsgbox* gameMsgBox, int missionCursor, bool bCheck)
{
	ForceEndScript(gameScript, gameMsgBox);
	if (missionCursor < missionList.size())
	{
		gameScript->EndEvent();
		gameMsgBox->CLR();
		auto iter = missionList.begin();
		for (int index = 0; index < missionCursor; iter++)
			index++;
		auto& mission = *iter;
		auto& missionReg = missionRegList.at(mission.regID);
		if (bCheck)
			gameScript->StartEvent(missionReg.checkFName.c_str(), L"tBoot");
		else
			gameScript->StartEvent(missionReg.fName.c_str(), L"tBoot");
	}
	else
	{
		//ûѡƷ
		ForceEndScript(gameScript, gameMsgBox);
		gameMsgBox->CLO();
	}
}

void ItemSystem::MissionMenuScript(GameScript* gameScript, GameMsgbox* gameMsgBox, int missionCursor)
{
	if (gameScript->IsRunning() || gameScript->GetW99())
		return;
	//Ʒ
	MissionMenuUpdate(gameScript, gameMsgBox, missionCursor);
}

void ItemSystem::DrawPanel_Player1(float offx, float offy)
{
	std::wstring style = pGameMsgBox->GetMsgBoxStyle();
	if (style.length() == 0)
		style = L"default";
	auto& tas = *GetMsgboxTexture(style.c_str());
	std::weak_ptr<Entity> player = pEntityRes->GetMyChar_Player1();
	auto playerUI = pGameUI->GetPlayerUIData(0);
	MyView& view = *pView;
	MyRect src, dst;
	float src_x, src_y, src_w, src_h;
	float dst_x, dst_y, dst_w, dst_h;
	//Ʊ
	src.Set1(0, 208, 32, 32);
	dst_x = itemsys_x + (16 + offx) * view.scale;
	dst_y = itemsys_y + (64 + offy) * view.scale;
	dst_w = 32 * view.scale;
	dst_h = 32 * view.scale;
	dst.Set1(dst_x, dst_y, dst_w, dst_h);
	pRenderer->SetTPenDraw(tas.pSRV);
	pRenderer->AddRenderCopy(&src, &dst);
	//Ƽ
	src.Set1(0, 176, 20, 20);
	for (int i = 0; i < 6; i++)
	{
		dst_x = itemsys_x + (16 + i * 21 + offx) * view.scale;
		dst_y = itemsys_y + (118 + offy) * view.scale;
		dst_w = 20 * view.scale;
		dst_h = 20 * view.scale;
		dst.Set1(dst_x, dst_y, dst_w, dst_h);
		pRenderer->AddRenderCopy(&src, &dst);
	}
	pRenderer->DrawRenderCopy();
	//
	float barDy = 3;
	auto& tas_ui = *GetSysTexture(L"ui");
	pRenderer->SetTPenDraw(tas_ui.pSRV);
	src.Set1(0, 0, 46, 9);
	dst.Set1(itemsys_x + (50 + offx) * view.scale,
		itemsys_y + (64 + offy + barDy) * view.scale,
		46 * view.scale, 9 * view.scale);
	pRenderer->AddRenderCopy(&src, &dst);
	//ͶƷ
	src_w = src_h = 10;
	dst_y = itemsys_y + (142 + offy) * view.scale;
	dst_w = dst_h = 10 * view.scale;
	int i = 0;
	for (auto& p : playerUI->throwItem)
	{
		if (p == 0)
			continue;
		src_x = (abs(p) - 1) * 10.0f;
		src_y = 32.0f;
		src_y += (float)(playerUI->appearEffect_counter[i] / 6) * 10;
		if (p < 0)
			src_y += (float)(playerUI->disappearEffect_counter[i] / 6 + 1) * 10;
		dst_x = itemsys_x + (11 * i + 16 + offx) * view.scale;
		src.Set1(src_x, src_y, src_w, src_h);
		dst.Set1(dst_x, dst_y, dst_w, dst_h);
		pRenderer->AddRenderCopy(&src, &dst);
		i++;
	}
	pRenderer->DrawRenderCopy();
	//Ѫ
	auto& tas_mcui = *GetMcuiTexture(playerUI->uiName.c_str());
	pRenderer->SetTPenDraw(tas_mcui.pSRV);
	src.Set1(0, 192, 50, 8);
	dst.Set1(itemsys_x + (50 + offx) * view.scale,
		itemsys_y + (74 + offy + barDy) * view.scale,
		50 * view.scale, 8 * view.scale);
	pRenderer->AddRenderCopy(&src, &dst);
	DrawAddNum(68, 102,
		itemsys_x / view.scale + 60 + offx,
		itemsys_y / view.scale + 76 + offy + barDy, playerUI->Hp);
	DrawAddNum(68, 102,
		itemsys_x / view.scale + 82 + offx,
		itemsys_y / view.scale + 76 + offy + barDy, playerUI->HpMax);
	//ħ
	src.Set1(0, 200, 50, 8);
	dst.Set1(itemsys_x + (50 + offx) * view.scale,
		itemsys_y + (83 + offy + barDy) * view.scale,
		50 * view.scale, 8 * view.scale);
	pRenderer->AddRenderCopy(&src, &dst);
	DrawAddNum(68, 107,
		itemsys_x / view.scale + 60 + offx,
		itemsys_y / view.scale + 85 + offy + barDy, playerUI->Mp);
	DrawAddNum(68, 107,
		itemsys_x / view.scale + 82 + offx,
		itemsys_y / view.scale + 85 + offy + barDy, playerUI->MpMax);
	//Ҽ
	{
		int* skillArrPtr = playerUI->SkillArr;
		bool* skillDisablePtr = playerUI->SkillDisable;
		float* skillCDArrPtr = playerUI->SkillCDArr;
		if (playerUI->bShowChildMenu)
		{
			skillArrPtr = playerUI->SkillArr_ChildMenu;
			skillDisablePtr = playerUI->SkillDisable_ChildMenu;
			skillCDArrPtr = playerUI->SkillCDArr_ChildMenu;
		}
		src_w = src_h = 16;
		dst_w = dst_h = 16 * view.scale;
		for (int i = 0; i < 6; i++)
		{
			if (skillArrPtr[i] < 0)
				continue;
			src_x = skillArrPtr[i] * 16.0f;
			src_y = 112;
			if (skillDisablePtr[i])
				src_y += 32;
			src_h = 16;
			dst_x = itemsys_x + (18 + i * 21 + offx) * view.scale;
			dst_y = itemsys_y + (120 + offy) * view.scale;
			dst_h = src_h * view.scale;
			//ȴͼ
			src.Set1(src_x, src_y + 16, src_w, src_h);
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
			//ͼ
			src_h = 16 * skillCDArrPtr[i];
			src_y = 112 + 16 - src_h;
			dst_y = itemsys_y + (120 + 16 - src_h + offy) * view.scale;
			if (skillDisablePtr[i])
				src_y += 32;
			dst_h = src_h * view.scale;
			src.Set1(src_x, src_y, src_w, src_h);
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
	}
	pRenderer->DrawRenderCopy();
}

void ItemSystem::DrawPanel_Player2(float offx, float offy)
{
	std::wstring style = pGameMsgBox->GetMsgBoxStyle();
	if (style.length() == 0)
		style = L"default";
	auto& tas = *GetMsgboxTexture(style.c_str());
	std::weak_ptr<Entity> player = pEntityRes->GetMyChar_Player2();
	auto playerUI = pGameUI->GetPlayerUIData(1);
	MyView& view = *pView;
	MyRect src, dst;
	float src_x, src_y, src_w, src_h;
	float dst_x, dst_y, dst_w, dst_h;
	//Ʊ
	src.Set1(0, 208, 32, 32);
	dst_x = itemsys_x + (16 + offx) * view.scale;
	dst_y = itemsys_y + (64 + offy) * view.scale;
	dst_w = 32 * view.scale;
	dst_h = 32 * view.scale;
	dst.Set1(dst_x, dst_y, dst_w, dst_h);
	pRenderer->SetTPenDraw(tas.pSRV);
	pRenderer->AddRenderCopy(&src, &dst);
	//Ƽ
	src.Set1(0, 176, 20, 20);
	for (int i = 0; i < 6; i++)
	{
		dst_x = itemsys_x + (-78 + i * 21 + offx) * view.scale;
		dst_y = itemsys_y + (118 + offy) * view.scale;
		dst_w = 20 * view.scale;
		dst_h = 20 * view.scale;
		dst.Set1(dst_x, dst_y, dst_w, dst_h);
		pRenderer->AddRenderCopy(&src, &dst);
	}
	pRenderer->DrawRenderCopy();
	//
	auto wplayer2 = pEntityRes->GetMyChar_Player2().lock();
	float barDy = 3;
	auto& tas_ui = *GetSysTexture(L"ui");
	pRenderer->SetTPenDraw(tas_ui.pSRV);
	if (wplayer2 && wplayer2->enableAI)
	{
		//ʾaiʶ
		src.Set1(0, 18, 53, 9);
		dst.Set1(itemsys_x + (-39 + offx) * view.scale,
			itemsys_y + (64 + offy + barDy) * view.scale,
			53 * view.scale, 9 * view.scale);
	}
	else
	{
		//ʾ2ʶ
		src.Set1(0, 9, 46, 9);
		dst.Set1(itemsys_x + (-32 + offx) * view.scale,
			itemsys_y + (64 + offy + barDy) * view.scale,
			46 * view.scale, 9 * view.scale);
	}
	pRenderer->AddRenderCopy(&src, &dst);
	//ͶƷ
	src_w = src_h = 10;
	dst_y = itemsys_y + (142 + offy) * view.scale;
	dst_w = dst_h = 10 * view.scale;
	int i = 0;
	for (auto& p : playerUI->throwItem)
	{
		if (p == 0)
			continue;
		src_x = (abs(p) - 1) * 10.0f;
		src_y = 32.0f;
		src_y += (float)(playerUI->appearEffect_counter[i] / 6) * 10;
		if (p < 0)
			src_y += (float)(playerUI->disappearEffect_counter[i] / 6 + 1) * 10;
		dst_x = itemsys_x + (-11 * i + 37 + offx) * view.scale;
		src.Set1(src_x, src_y, src_w, src_h);
		dst.Set1(dst_x, dst_y, dst_w, dst_h);
		pRenderer->AddRenderCopy(&src, &dst);
		i++;
	}
	pRenderer->DrawRenderCopy();
	//Ѫ
	auto& tas_mcui = *GetMcuiTexture(playerUI->uiName.c_str());
	pRenderer->SetTPenDraw(tas_mcui.pSRV);
	src.Set1(0, 192 + 16, 50, 8);
	dst.Set1(itemsys_x + (-36 + offx) * view.scale,
		itemsys_y + (74 + offy + barDy) * view.scale,
		50 * view.scale, 8 * view.scale);
	pRenderer->AddRenderCopy(&src, &dst);
	DrawAddNum(68, 102,
		itemsys_x / view.scale + -33 + offx,
		itemsys_y / view.scale + 76 + offy + barDy, playerUI->Hp, true);
	DrawAddNum(68, 102,
		itemsys_x / view.scale + -11 + offx,
		itemsys_y / view.scale + 76 + offy + barDy, playerUI->HpMax, true);
	//ħ
	src.Set1(0, 200 + 16, 50, 8);
	dst.Set1(itemsys_x + (-36 + offx) * view.scale,
		itemsys_y + (83 + offy + barDy) * view.scale,
		50 * view.scale, 8 * view.scale);
	pRenderer->AddRenderCopy(&src, &dst);
	DrawAddNum(68, 107,
		itemsys_x / view.scale + -33 + offx,
		itemsys_y / view.scale + 85 + offy + barDy, playerUI->Mp, true);
	DrawAddNum(68, 107,
		itemsys_x / view.scale + -11 + offx,
		itemsys_y / view.scale + 85 + offy + barDy, playerUI->MpMax, true);
	//Ҽ
	{
		int* skillArrPtr = playerUI->SkillArr;
		bool* skillDisablePtr = playerUI->SkillDisable;
		float* skillCDArrPtr = playerUI->SkillCDArr;
		if (playerUI->bShowChildMenu)
		{
			skillArrPtr = playerUI->SkillArr_ChildMenu;
			skillDisablePtr = playerUI->SkillDisable_ChildMenu;
			skillCDArrPtr = playerUI->SkillCDArr_ChildMenu;
		}
		src_w = src_h = 16;
		dst_w = dst_h = 16 * view.scale;
		for (int i = 0; i < 6; i++)
		{
			if (skillArrPtr[i] < 0)
				continue;
			src_x = skillArrPtr[i] * 16.0f;
			src_y = 112;
			if (skillDisablePtr[i])
				src_y += 32;
			src_h = 16;
			dst_x = itemsys_x + (-76 + i * 21 + offx) * view.scale;
			dst_y = itemsys_y + (120 + offy) * view.scale;
			dst_h = src_h * view.scale;
			//ȴͼ
			src.Set1(src_x, src_y + 16, src_w, src_h);
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
			//ͼ
			src_h = 16 * skillCDArrPtr[i];
			src_y = 112 + 16 - src_h;
			dst_y = itemsys_y + (120 + 16 - src_h + offy) * view.scale;
			if (skillDisablePtr[i])
				src_y += 32;
			dst_h = src_h * view.scale;
			src.Set1(src_x, src_y, src_w, src_h);
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
	}
	pRenderer->DrawRenderCopy();
}

void ItemSystem::DrawAddEntity(std::shared_ptr<Entity>& we, float offx, float offy)
{
	MyView& view = *pView;
	MyRect src, dst;
	//ʵ
	MyView viewSrc = view;
	view.offX = view.offY = 0;
	float xSrc = we->x;
	float ySrc = we->y;
	float xDraw = we->draw_x;
	float yDraw = we->draw_y;
	we->draw_x = we->x = itemsys_x / view.scale + offx + 32;
	we->draw_y = we->y = itemsys_y / view.scale + offy + 80;
	pEntityRes->DrawAddEntity(we);
	view = viewSrc;
	we->x = xSrc;
	we->y = ySrc;
	we->draw_x = xDraw;
	we->draw_y = yDraw;
}

void ItemSystem::DrawAddEntity2(std::shared_ptr<Entity>& we, float offx, float offy)
{
	MyView& view = *pView;
	MyRect src, dst;
	//ʵ
	MyView viewSrc = view;
	view.offX = view.offY = 0;
	float xSrc = we->x;
	float ySrc = we->y;
	float xDraw = we->draw_x;
	float yDraw = we->draw_y;
	we->draw_x = we->x = offx;
	we->draw_y = we->y = offy;
	pEntityRes->DrawAddEntity(we);
	view = viewSrc;
	we->x = xSrc;
	we->y = ySrc;
	we->draw_x = xDraw;
	we->draw_y = yDraw;
}

void ItemSystem::DrawAddNum(float srcX, float srcY, float dstX, float dstY, int num, bool order)
{
	MyView& view = *pView;
	MyRect src, dst;

	char numbuff[16];
	sprintf_s(numbuff, "%d", num);
	int len = (int)strlen(numbuff);
	int begin = (4 - len) * 4;
	int time = 0;
	if (order)
	{
		//
		begin = 0;
	}
	else
	{
		//
		begin = (4 - len) * 4;
	}
	for (int i = 0; i < len; i++)
	{
		src.Set1(srcX + (numbuff[i] - '0') * 3, srcY, 3, 5);
		dst.Set1((dstX + time + begin) * view.scale,
			(dstY)*view.scale,
			3 * view.scale, 5 * view.scale);
		pRenderer->AddRenderCopy(&src, &dst);
		time += 4;
	}
}

void ItemSystem::DrawAddEntity_Icon(std::shared_ptr<Entity>& we, float offx, float offy)
{
	MyView& view = *pView;
	MyRect src, dst;
	//ʵ
	MyView viewSrc = view;
	view.offX = -(itemsys_x / view.scale + offx + 32);
	view.offY = -(itemsys_y / view.scale + offy + 80);
	pEntityRes->DrawAddEntity(we);
	view = viewSrc;
}

void ItemSystem::DrawAddEntity2_Icon(std::shared_ptr<Entity>& we, float offx, float offy)
{
	MyView& view = *pView;
	MyRect src, dst;
	//ʵ
	MyView viewSrc = view;
	view.offX = -offx;
	view.offY = -offy;
	pEntityRes->DrawAddEntity(we);
	view = viewSrc;
}

void ItemSystem::DrawAddItemIconEntity()
{
	for (int y = 0; y < 3; y++)
	{
		for (int x = 0; x < 9; x++)
		{
			auto& item = itemList[y * 9 + x];
			if (item.num <= 0)
				continue;
			auto we = item.e.lock();
			if (we)
				DrawAddEntity_Icon(we, x * 32.0f, 84.0f + y * 32);
		}
	}
}

void ItemSystem::DrawMiniItem()
{
	MyView& view = *pView;
	//Ʒ򱳾
	std::wstring style = pGameMsgBox->GetMsgBoxStyle();
	if (style.length() == 0)
		style = L"default";
	auto& tas = *GetMsgboxTexture(style.c_str());
	float src_x, src_y;
	float dst_x, dst_y, dst_w, dst_h;
	const float msgbox_grid_w = 16;
	const float msgbox_grid_h = 16;
	dst_w = view.grid_w * view.scale;
	dst_h = view.grid_h * view.scale;

	MyRect src, dst;
	pRenderer->SetTPenDraw(tas.pSRV);
	//
	int wCount = 7;
	int hCount = 4;
	for (int Y = 0; Y < hCount; Y++)
	{
		for (int X = 0; X < wCount; X++)
		{
			if (X == 0)
				src_x = 48;
			else if (X == wCount - 1)
				src_x = 80;
			else
				src_x = 64;
			if (Y == 0)
				src_y = 48;
			else if (Y == hCount - 1)
				src_y = 80;
			else
				src_y = 64;
			dst_x = view.window_w / 2 - wCount * view.grid_w * view.scale / 2 + X * dst_w;
			dst_y = view.window_h / 2 - hCount * view.grid_h * view.scale / 2 + Y * dst_h;
			src.Set1(src_x, src_y, msgbox_grid_w, msgbox_grid_h);
			dst.Set1(dst_x, dst_y, dst_w, dst_h);
			pRenderer->AddRenderCopy(&src, &dst);
		}
	}
	//չʾ
	src.Set1(32, 208, 32, 32);
	dst_x = view.window_w / 2 - 32 * view.scale / 2;
	dst_y = view.window_h / 2 - 32 * view.scale / 2;
	dst_w = 32 * view.scale;
	dst_h = 32 * view.scale;
	dst.Set1(dst_x, dst_y, dst_w, dst_h);
	pRenderer->AddRenderCopy(&src, &dst);
	pRenderer->DrawRenderCopy();
	auto we = miniItem.e.lock();
	if (we)
		DrawAddEntity2_Icon(we, view.window_w / view.scale / 2, view.window_h / view.scale / 2);
	pEntityRes->DrawEntity();
}

void ItemSystem::DrawAddMissionIconEntity()
{
	MyView& view = *pView;
	int index = 0;
	for (auto& missionData : missionList)
	{
		MissionRegister& reg = missionRegList.at(missionData.regID);
		float nextX = 4;
		float nextY = (index - 1) * 24.0f;
		auto we = missionData.e.lock();
		if (we)
			DrawAddEntity_Icon(we, nextX, nextY);
		index++;
	}
}
