#include "GameTimer.h"
#include "main.h"
void GameTimer::Init(MyDX11Renderer* pRenderer, MyView* pView)
{
    this->pRenderer = pRenderer;
    this->pView = pView;
}

void GameTimer::Draw(bool bShowPlayer2)
{
    if (!bVisiable)
        return;
    auto& tas = *GetSysTexture(L"dmgnum");
    pRenderer->SetTPenDraw(tas.pSRV);
    float offx = pView->window_w - pView->scale * 64;
    float offy = pView->scale * 16;
    if (bShowPlayer2)
    {
        //м
        offx = (pView->window_w - 16 * pView->scale) / 2;
    }
    MyRect src, dst;
    //Ʒ
    AddDrawNum(0, 56, offx, offy, pView->scale, minutes);
    src.Set1(64, 0, 8, 8);
    dst.Set1(offx, offy, 8 * pView->scale, 8 * pView->scale);
    pRenderer->AddRenderCopy(&src, &dst);
    //
    AddDrawTwoNum(0, 56, offx + 5 * pView->scale, offy, pView->scale, seconds);
    src.Set1(72, 0, 8, 8);
    dst.Set1(offx + 21 * pView->scale, offy, 8 * pView->scale, 8 * pView->scale);
    pRenderer->AddRenderCopy(&src, &dst);
    //1/10
    AddDrawOneNum(0, 56, offx + 26 * pView->scale, offy, pView->scale, units);
    //ʱ
    if (counter % 60 < 30)
        src.Set1(48, 0, 8, 8);
    else
        src.Set1(56, 0, 8, 8);
    dst.Set1(offx - 32 * pView->scale, offy, 8 * pView->scale, 8 * pView->scale);
    pRenderer->AddRenderCopy(&src, &dst);
    pRenderer->DrawRenderCopy();
}

void GameTimer::Step()
{
    if (bStop)
        return;
    SetUnit();
    counter++;
}

void GameTimer::Reset()
{
    counter = 0;
    bVisiable = false;
    bStop = true;
    SetUnit();
}

void GameTimer::SetVisible(bool bVisiable)
{
    this->bVisiable = bVisiable;
}

void GameTimer::Stop(bool bStop)
{
    this->bStop = bStop;
}

int GameTimer::GetCounter()
{
    return counter;
}

void GameTimer::SetCounter(int counter)
{
    this->counter = counter;
}

bool GameTimer::Save()
{
    //浱ǰֵ
    int counterNew = counter;
    bool bNewRecord = false;
    if (Load())
    {
        //¼¼
        if (counterNew < counter)
            bNewRecord = true;
    }
    else
    {
        bNewRecord = true;
    }
    if (bNewRecord)
    {
        counter = counterNew;
        SetUnit();
        //ʱݵϷĿ¼
        tinyxml2::XMLDocument xmlDoc;
        auto elem_bossrush = xmlDoc.NewElement("BossRush");
        elem_bossrush->SetAttribute("NikumaruCounter", counterNew);
        xmlDoc.InsertEndChild(elem_bossrush);
        tinyxml2::XMLPrinter xmlPrinter;
        xmlDoc.Print(&xmlPrinter);
        //ѹ
        std::vector<BYTE> compressData;
        size_t compressData_len;
        ZLibCompressData(&compressData, &compressData_len, xmlPrinter.CStr(), xmlPrinter.CStrSize());
        //д뱾ļ
        const wchar_t* filename = L"./290.sav";
        FILE* fp;
        _wfopen_s(&fp, filename, L"wb+");
        if (!fp)
        {
            wchar_t err[MAX_PATH];
            swprintf_s(err, L"ϷĿ¼%sʧ", filename);
            MessageBoxW(hwnd, err, L"ļдʧ", MB_ICONWARNING);
            return false;
        }
        fwrite(compressData.data(), compressData_len, 1, fp);
        fclose(fp);
        return true;
    }
    return false;
}

bool GameTimer::Load()
{
    const wchar_t* filename = L"./290.sav";
    //ȡʱ
    FILE* fp;
    _wfopen_s(&fp, filename, L"rb");
    if (!fp)
        return false;
    std::vector<BYTE> cbuff;
    fseek(fp, 0, SEEK_END);
    size_t fileLen = ftell(fp);
    fseek(fp, 0, SEEK_SET);
    cbuff.resize(fileLen);
    fread_s(cbuff.data(), fileLen, fileLen, 1, fp);
    fclose(fp);
    std::vector<BYTE> byte_buff;
    size_t len = 0;
    ZLibUncompressData(&byte_buff, &len, cbuff.data(), fileLen);
    tinyxml2::XMLDocument xmlDoc;
    xmlDoc.Parse((const char*)byte_buff.data());
    //ѰBossRushԪ
    tinyxml2::XMLElement* elem = nullptr;
    for (tinyxml2::XMLElement* pElem = xmlDoc.FirstChildElement(); pElem; pElem = pElem->NextSiblingElement())
    {
        if (!strcmp(pElem->Name(), "BossRush"))
        {
            elem = pElem;
            break;
        }
    }
    if (elem)
    {
        //ȡBossRushԪ
        counter = elem->IntAttribute("NikumaruCounter");
        SetUnit();
        return true;
    }
    return false;
}

void GameTimer::SetUnit()
{
    const int FRAMES_PER_SECOND = 60; // Ϸ֡60FPS
    const int UNITS_PER_SECOND = 10;  // ÿΪ10λ

    int totalUnits = (counter * UNITS_PER_SECOND) / FRAMES_PER_SECOND;

    units = totalUnits % UNITS_PER_SECOND;
    int totalSeconds = totalUnits / UNITS_PER_SECOND;
    seconds = totalSeconds % 60;
    minutes = totalSeconds / 60;
}

void GameTimer::AddDrawOneNum(float srcX, float srcY, float dstX, float dstY, float scale, int num)
{
    MyRect src, dst;
    src.Set1(srcX + num * 8, srcY, 8, 8);
    dst.Set1(dstX, dstY, 8 * scale, 8 * scale);
    pRenderer->AddRenderCopy(&src, &dst);
}

void GameTimer::AddDrawTwoNum(float srcX, float srcY, float dstX, float dstY, float scale, int num)
{
    // ȷ0-99Χ
    num = SDL_clamp(num, 0, 99);
    // ȡʮλ͸λ
    int tens = num / 10;
    int ones = num % 10;
    // ʮλ
    AddDrawOneNum(srcX, srcY, dstX, dstY, scale, tens);
    // Ƹλ (ƫһֵĿ)
    AddDrawOneNum(srcX, srcY, dstX + 8 * scale, dstY, scale, ones);
}

void GameTimer::AddDrawNum(float srcX, float srcY, float dstX, float dstY, float scale, int num)
{
    // תΪַ
    std::string numStr = std::to_string(num);
    // ܿȣҶ룩
    float totalWidth = numStr.length() * 8 * scale;
    MyRect src, dst;
    // ҵÿ
    for (size_t i = 0; i < numStr.length(); ++i) 
    {
        int digit = numStr[i] - '0';  // ַתΪ

        // 㵱ǰֵλãҶ룩
        float xPos = dstX + (i * 8 * scale) - totalWidth;
        // Ƶ
        src.Set1(srcX + digit * 8, srcY, 8, 8);
        dst.Set1(xPos, dstY, 8 * scale, 8 * scale);
        pRenderer->AddRenderCopy(&src, &dst);
    }
}
