#pragma once
#include "global.h"
#include "MyStructDef.h"
#include "GamePid.h"
#include "EntityDll.h"
#include "PathfindingE.h"
//ʵԴOcStore
struct GroupByDraw
{
	MyRect src, dst;
	DWORD color;
};

class EntityRes
{
public:
	//GameFunc
	static std::unordered_map<MapLayer*, EntityLayer>* GetLoadedEntity(EntityRes* entityRes);
	//EntityRes
	EntityRes();
	virtual ~EntityRes();
	EntityRes(const EntityRes&) = delete;//ֹʵ
	EntityRes& operator=(const EntityRes&) = delete;//ֹʵ
	void Init(MyDX11Renderer* pRenderer, MyView* pView, int* pMapW, int* pMapH);
	void Reset();//
	void RefreshImage();
	void StepEntityLayer(MyMapLayer* pLayer);//ִһʵ
	void StepEntityLayerPe(MyMapLayer* pLayer);//ִֻиʵеЧʵ
	void DrawEntityLayer(MyMapLayer* pLayer, bool bApplyMyFar, bool inTopDraw = false);//һʵ
	void DeltaTimeEntityLayer(MyMapLayer* pLayer, float deltaTime);//ִһʵ
	void DrawAddEntity(std::shared_ptr<Entity>& we, bool inTopDraw = false);
	void DrawShaderEntity(std::shared_ptr<Entity>& we, bool inTopDraw = false);//ɫʵ
	void DrawEntity();
	void DrawEntityText(std::weak_ptr<Entity> e, DWORD color, bool inTopDraw = false);//ʵı
	void DrawEntityCbRectLayer(MyMapLayer* pLayer);//ʵײ
	void EntityInitCheck(std::shared_ptr<Entity>& we);
	void EntitySharedPtrCheck(std::shared_ptr<Entity>& we);
	void StepList(std::list<std::shared_ptr<Entity>>* entityList);
	void GetLoadedEntityDllInfo(std::unordered_map<std::wstring, std::vector<std::wstring>>* infoList);
	void AmStep(EntityLayer* entityLayer);//ҩײ
	bool AmTarget(std::shared_ptr<Entity>& am, std::shared_ptr<Entity>& target);
	static void CollisionEntity(std::weak_ptr<Entity> e, std::vector<LONG>* pxmArr, std::vector<int>* pxaArr, std::map<LONG, LONG>* updatedPxmArr, int pxmArr_w, int pxaArr_w);
	static void CollisionEntityBig(std::weak_ptr<Entity> e, std::vector<LONG>* pxmArr, std::vector<int>* pxaArr, std::map<LONG, LONG>* updatedPxmArr, int pxmArr_w, int pxaArr_w);
	static void CollisionEntitySmall(std::weak_ptr<Entity> e, std::vector<LONG>* pxmArr, std::vector<int>* pxaArr, std::map<LONG, LONG>* updatedPxmArr, int pxmArr_w, int pxaArr_w);
	void CollisionMovingPlatform(std::weak_ptr<Entity> e);
	static void SetEntity(std::shared_ptr<Entity> parent, std::shared_ptr<Entity> newE);
	void SetCollisionEntityLayer(MyMapLayer* pLayer, PxaData* pxaData);
	CString entityLanguage;
	void ReloadLanguage();//Բ
	CString GetErrorMsg();
	ID3D11VertexShader* GetVertexShader(const wchar_t* vsName);//ȡɫ
	ID3D11PixelShader* GetPixelShader(const wchar_t* psName);//ȡɫ
	static void GetDisplayInfo(EntityRes* pEntityRes, float* outWindow_w, float* outWindow_h, float* outScale, float* outOffX, float* outOffY);
	static void GetMousePos(EntityRes* pEntityRes, float* pX, float* pY);
	static bool InScreen(EntityRes* pEntityRes, float x, float y);//ǷĻʾΧ
	static void GridTouch(EntityRes* entityRes, std::weak_ptr<Entity> src, EntityLayer* targetLayer);//ȡʵӴʵ
	void ClearLightList();//һεķʵ¼
	void DrawLightEntity(MyMapLayer* pLayer, bool playing);//Ʒʵ
	void MarkLightEntity(MyMapLayer* pLayer);//ǵǰеĵƹʵ
    static PathCell* GetPath(std::weak_ptr<Entity> e, float dstX, float dstY, float srcX, float srcY);
    static bool LineTest(std::weak_ptr<Entity> e, float srcX, float srcY, float dstX, float dstY);
	void UpdatePathFinder();
	static void GetMapSize(EntityRes* pEntityRes, int* outMapW, int* outMapH);
	void GridRemoveEntity(std::shared_ptr<Entity>& e);
	void GridSetEntity(std::shared_ptr<Entity>& e);
private:
	MyDX11Renderer* pRenderer = nullptr;
	MyView* pView = nullptr;
    int* pMapW = nullptr;
    int* pMapH = nullptr;
	GamePid gamePid;
	std::unordered_map<MyMapLayer*, EntityLayer> loadedEntity;
	std::unordered_map<std::wstring, MyTextureAndSRV> loadedPidTexture;
	TTF_Font* myfont14 = nullptr;
	std::unordered_map<wchar_t, MyFontData> fontMap_myfont14;
	std::unordered_map<std::wstring, std::vector<GroupByDraw>> groupByDraw;
	std::vector<MyDX11PenVertex> lineList;
	std::vector<MyDX11PenVertex> fillList;
	MyTextureAndSRV* GetPidTexture(CString pidName);
	EntityLayer* GetEntityLayer(MyMapLayer* pLayer);
	std::weak_ptr<Entity> LoadEntity(const EntityLoad* el, MyMapLayer* pLayer, EntityLayer* entityLayer);
	void LoadEntityDll();
	static std::shared_ptr<Entity> GameCreateEntity(const wchar_t* name);
	void EntityAniStep(std::shared_ptr<Entity>& we);
	void ClearTexture(std::unordered_map<std::wstring, MyTextureAndSRV>* textureRes);
	CString err;
	void DrawAddEntityCbRect(std::weak_ptr<Entity> e, DWORD c);
	//ɫ
	std::unordered_map<std::wstring, ID3D11VertexShader*> loadedVertexShader;//Ķɫ
	std::unordered_map<std::wstring, ID3D11PixelShader*> loadedPixelShader;//ɫ
	//ʵԤȾ
	ExTextureBuffer preTexture;
	ID3D11Texture2D* GetPreTexture(UINT w, UINT h);
	//ʵ
	std::vector<std::weak_ptr<Entity>> lightList;//ʵ
	//ײŻ
	void GridItemTarget(std::shared_ptr<Entity>& we);
	bool GridAmTarget(std::shared_ptr<Entity>& we);
    //Ѱ·ϵͳ
    std::unordered_map<EntityLayer*, PathfindingE> pfSys;
	//¼
	static void DecodeRecord(const wchar_t* recordStr, const void** outInputArr, size_t* outDataSize);
};
