#include "CSetSnapshot.h"
#include "resource.h"
#include <ShlObj_core.h>

IMPLEMENT_DYNAMIC(CSetSnapshot, CDialog)

BEGIN_MESSAGE_MAP(CSetSnapshot, CDialog)
	ON_BN_CLICKED(IDOK, &CSetSnapshot::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE_ASEAPP, &CSetSnapshot::OnBnClickedButtonBrowseAseapp)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE_SAVEAS, &CSetSnapshot::OnBnClickedButtonBrowseSaveas)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE_PATH, &CSetSnapshot::OnBnClickedButtonBrowsePath)
END_MESSAGE_MAP()

CSetSnapshot::CSetSnapshot(CWnd* pParent)
	: CDialog(IDD_CMAPEDITOR_SETSNAPSHOT, pParent)
{
}

CSetSnapshot::~CSetSnapshot()
{
}

void CSetSnapshot::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_ASEAPP, edit_aseApp);
	DDX_Control(pDX, IDC_EDIT_SAVEAS, edit_saveAs);
	DDX_Control(pDX, IDC_EDIT_PATH, edit_path);
	DDX_Control(pDX, IDC_EDIT_FILENAME, edit_filename);
	DDX_Control(pDX, IDC_BUTTON_BROWSE_ASEAPP, button_aseApp);
	DDX_Control(pDX, IDC_BUTTON_BROWSE_SAVEAS, button_saveAs);
	DDX_Control(pDX, IDC_BUTTON_BROWSE_PATH, button_path);
}

std::wstring GetDesktopPath()
{
	PWSTR path = nullptr;
	HRESULT hr = SHGetKnownFolderPath(FOLDERID_Desktop, 0, nullptr, &path);
	if (SUCCEEDED(hr)) {
		std::wstring desktopPath(path);
		CoTaskMemFree(path); // ͷڴ
		return desktopPath;
	}
	return L""; // ʧܷؿַ
}

BOOL CSetSnapshot::OnInitDialog()
{
	CDialog::OnInitDialog();
	//дAsepriteExe·
	wchar_t buff[MAX_PATH];
	CString inipath;
	GetModuleFileNameW(nullptr, buff, _countof(buff));
	inipath = buff;
	auto index = inipath.ReverseFind(L'\\');
	inipath.Delete(index, inipath.GetLength() - index);
	inipath.Append(L"\\ocstore.ini");

	DWORD result = GetPrivateProfileStringW(
		L"OCSTORE",
		L"AsepriteExePath",
		L"",  // Ĭֵ򷵻ֵ
		buff,
		_countof(buff),
		inipath.GetString()
	);
	if (result > 0 && buff[0] != '\0')
	{
		//дһεAseprite·
		edit_aseApp.SetWindowTextW(buff);
	}
	else
	{
		//дĬ·
		edit_aseApp.SetWindowTextW(LR"(C:\Program Files (x86)\Steam\steamapps\common\Aseprite\Aseprite.exe)");
	}

	//дмļ·
	result = GetPrivateProfileStringW(
		L"OCSTORE",
		L"IntermediateFilePath",
		L"",  // Ĭֵ򷵻ֵ
		buff,
		_countof(buff),
		inipath.GetString()
	);
	if (result > 0 && buff[0] != '\0')
	{
		//дһεAseprite·
		edit_path.SetWindowTextW(buff);
	}
	else
	{
		//дĬ·
		edit_path.SetWindowTextW(GetDesktopPath().c_str());
	}

	//дļĿ¼
	result = GetPrivateProfileStringW(
		L"OCSTORE",
		L"SnapshotOutputPath",
		L"",  // Ĭֵ򷵻ֵ
		buff,
		_countof(buff),
		inipath.GetString()
	);
	if (result > 0 && buff[0] != '\0')
	{
		//дһεAseprite·
		edit_saveAs.SetWindowTextW(buff);
	}
	else
	{
		//дĬ·
		edit_saveAs.SetWindowTextW(GetDesktopPath().c_str());
	}
	edit_filename.SetWindowTextW(inFilename.GetString());
	return 0;
}
void CSetSnapshot::OnBnClickedOk()
{
	// TODO: ڴӿؼ֪ͨ
	edit_aseApp.GetWindowTextW(outAseApp);
	if (_taccess(outAseApp.GetString(), 0) != 0)
	{
		MessageBoxW(L"Ӧóļ·", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	edit_saveAs.GetWindowTextW(outSaveAs);
	if (!PathIsDirectoryW(outSaveAs.GetString()))
	{
		MessageBoxW(L"Ŀ¼", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	edit_path.GetWindowTextW(outPath);
	if (!PathIsDirectoryW(outPath.GetString()))
	{
		MessageBoxW(L"мĿ¼", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	edit_filename.GetWindowTextW(outFilename);
	//浽iniļ
	wchar_t buff[MAX_PATH];
	CString inipath;
	GetModuleFileNameW(nullptr, buff, _countof(buff));
	inipath = buff;
	auto index = inipath.ReverseFind(L'\\');
	inipath.Delete(index, inipath.GetLength() - index);
	inipath.Append(L"\\ocstore.ini");

	WritePrivateProfileStringW(L"OCSTORE", L"AsepriteExePath", outAseApp.GetString(), inipath.GetString());
	WritePrivateProfileStringW(L"OCSTORE", L"IntermediateFilePath", outPath.GetString(), inipath.GetString());
	WritePrivateProfileStringW(L"OCSTORE", L"SnapshotOutputPath", outSaveAs.GetString(), inipath.GetString());
	//
	CDialog::OnOK();
}

void CSetSnapshot::OnBnClickedButtonBrowseAseapp()
{
	CFileDialog fd(false, TEXT(""), TEXT("Aseprite.exe"), OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT, TEXT("Ӧó(*.exe)|*.exe|ļ(*.*)|*.*||"), this);
	if (fd.DoModal() != IDOK)
		return;
	edit_aseApp.SetWindowText(fd.GetPathName());
}

void CSetSnapshot::OnBnClickedButtonBrowseSaveas()
{
	CFolderPickerDialog dlgFolder;

	// öԻ
	dlgFolder.m_ofn.lpstrTitle = _T("ѡ񵼳ļĿ¼");

	// ʾԻ򲢻ȡûѡ
	if (dlgFolder.DoModal() != IDOK)
		return;
	// ȡѡļ·
	edit_saveAs.SetWindowTextW(dlgFolder.GetFolderPath());
}

void CSetSnapshot::OnBnClickedButtonBrowsePath()
{
	CFolderPickerDialog dlgFolder;

	// öԻ
	dlgFolder.m_ofn.lpstrTitle = _T("ѡмļĿ¼");

	// ʾԻ򲢻ȡûѡ
	if (dlgFolder.DoModal() != IDOK)
		return;
	// ȡѡļ·
	edit_path.SetWindowTextW(dlgFolder.GetFolderPath());
}
