#include "CNewLayer.h"
#include "resource.h"
#include "CMapEditorDraw.h"

IMPLEMENT_DYNAMIC(CNewLayer, CDialog)

BEGIN_MESSAGE_MAP(CNewLayer, CDialog)
	ON_BN_CLICKED(IDOK, &CNewLayer::OnBnClickedOk)
	ON_BN_CLICKED(IDC_RADIO_MAINLAYER, &CNewLayer::OnBnClickedRadioMainlayer)
	ON_BN_CLICKED(IDC_RADIO_BKLAYER, &CNewLayer::OnBnClickedRadioBklayer)
	ON_BN_CLICKED(IDC_RADIO_LOOPBKLAYER, &CNewLayer::OnBnClickedRadioLoopbklayer)
	ON_CBN_SELCHANGE(IDC_COMBO_PXA, &CNewLayer::OnCbnSelchangeComboPxa)
	ON_EN_CHANGE(IDC_EDIT_COLOR_R, &CNewLayer::OnEnChangeEditColorR)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_COLOR_R, &CNewLayer::OnNMCustomdrawSliderColorR)
	ON_EN_CHANGE(IDC_EDIT_COLOR_G, &CNewLayer::OnEnChangeEditColorG)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_COLOR_G, &CNewLayer::OnNMCustomdrawSliderColorG)
	ON_EN_CHANGE(IDC_EDIT_COLOR_B, &CNewLayer::OnEnChangeEditColorB)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_COLOR_B, &CNewLayer::OnNMCustomdrawSliderColorB)
	ON_EN_CHANGE(IDC_EDIT_COLOR_A, &CNewLayer::OnEnChangeEditColorA)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_COLOR_A, &CNewLayer::OnNMCustomdrawSliderColorA)
	ON_EN_CHANGE(IDC_EDIT_COLOR_RGBA, &CNewLayer::OnEnChangeEditColorRgba)
	ON_EN_CHANGE(IDC_EDIT_DAYLIGHT, &CNewLayer::OnEnChangeEditDaylight)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_DAYLIGHT, &CNewLayer::OnNMCustomdrawSliderDaylight)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_H, &CNewLayer::OnEnChangeEditLightH)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_LIGHT_H, &CNewLayer::OnNMCustomdrawSliderLightH)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_S, &CNewLayer::OnEnChangeEditLightS)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_LIGHT_S, &CNewLayer::OnNMCustomdrawSliderLightS)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_V, &CNewLayer::OnEnChangeEditLightV)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_LIGHT_V, &CNewLayer::OnNMCustomdrawSliderLightV)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_CONST, &CNewLayer::OnEnChangeEditLightConst)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_LIGHT_CONST, &CNewLayer::OnNMCustomdrawSliderLightConst)
END_MESSAGE_MAP()

CNewLayer::CNewLayer(CWnd* pParent)
	: CDialog(IDD_CMAPEDITOR_NEWLAYER, pParent)
{
}

CNewLayer::~CNewLayer()
{
}

void CNewLayer::UpdateRGBACEdit()
{
	BYTE r = slider_color_r.GetPos();
	BYTE g = slider_color_g.GetPos();
	BYTE b = slider_color_b.GetPos();
	BYTE a = slider_color_a.GetPos();
	CString str, buff;
	str.Format(L"%02x", r);
	buff.Append(str.GetString());
	str.Format(L"%02x", g);
	buff.Append(str.GetString());
	str.Format(L"%02x", b);
	buff.Append(str.GetString());
	str.Format(L"%02x", a);
	buff.Append(str.GetString());
	inSingleRGBAEdit = true;
	edit_color_rgba.SetWindowTextW(buff.GetString());
	inSingleRGBAEdit = false;
	if (pDrawWnd)
	{
		pLayer->color = RGBA(r, g, b, a);
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}

DWORD CNewLayer::ColorString(const wchar_t* colorStr)
{
	CString strR, strG, strB, strA;
	CString colorRGBA = colorStr;
	DWORD r = 0, g = 0, b = 0, a = 0;
	if (colorRGBA.GetLength() > 1)//RR
	{
		strR.Append(colorRGBA.Left(2).GetString());
		if (swscanf_s(strR.GetString(), L"%x", &r) == -1)
			return RGBA(r, g, b, a);
	}
	else if (colorRGBA.GetLength() == 1)//R
	{
		strR.Append(colorRGBA.Left(1).GetString());
		strR.Append(L"0");
		if (swscanf_s(strR.GetString(), L"%x", &r) == -1)
			return RGBA(r, g, b, a);
	}
	if (colorRGBA.GetLength() > 3)//RR GG
	{
		strG.Append(colorRGBA.Left(4).Right(2).GetString());
		if (swscanf_s(strG.GetString(), L"%x", &g) == -1)
			return RGBA(r, g, b, a);
	}
	else if (colorRGBA.GetLength() == 3)//RR G
	{
		strG.Append(colorRGBA.Right(1).GetString());
		strG.Append(L"0");
		if (swscanf_s(strG.GetString(), L"%x", &g) == -1)
			return RGBA(r, g, b, a);
	}
	if (colorRGBA.GetLength() > 5)//RR GG BB
	{
		strB.Append(colorRGBA.Left(6).Right(2).GetString());
		if (swscanf_s(strB.GetString(), L"%x", &b) == -1)
			return RGBA(r, g, b, a);
	}
	else if (colorRGBA.GetLength() == 5)//RR GG B
	{
		strB.Append(colorRGBA.Right(1).GetString());
		strB.Append(L"0");
		if (swscanf_s(strB.GetString(), L"%x", &b) == -1)
			return RGBA(r, g, b, a);
	}
	if (colorRGBA.GetLength() > 7)//RR GG BB AA
	{
		strA.Append(colorRGBA.Left(8).Right(2).GetString());
		if (swscanf_s(strA.GetString(), L"%x", &a) == -1)
			return RGBA(r, g, b, a);
	}
	else if (colorRGBA.GetLength() == 7)
	{
		strA.Append(colorRGBA.Right(1).GetString());
		strA.Append(L"0");
		if (swscanf_s(strA.GetString(), L"%x", &a) == -1)
			return RGBA(r, g, b, a);
	}
	return RGBA(r, g, b, a);
}

void CNewLayer::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//
	DDX_Control(pDX, IDC_EDIT_LAYERNAME, edit_layerName);
	DDX_Control(pDX, IDC_COMBO_PXA, combo_pxa);
	//ͼ
	DDX_Control(pDX, IDC_RADIO_MAINLAYER, radio_mainLayer);
	DDX_Control(pDX, IDC_RADIO_BKLAYER, radio_bkLayer);
	DDX_Control(pDX, IDC_RADIO_LOOPBKLAYER, radio_loopBkLayer);
	//ͼ
	static_offx = (CStatic*)GetDlgItem(IDC_STATIC_OFFX);
	static_offy = (CStatic*)GetDlgItem(IDC_STATIC_OFFY);
	DDX_Control(pDX, IDC_EDIT_OFFX, edit_offx);
	DDX_Control(pDX, IDC_EDIT_OFFY, edit_offy);
	static_far = (CStatic*)GetDlgItem(IDC_STATIC_FAR);
	DDX_Control(pDX, IDC_EDIT_FAR, edit_far);
	//ѭ
	DDX_Control(pDX, IDC_CHECK_LOOPH, check_loopH);
	DDX_Control(pDX, IDC_CHECK_LOOPV, check_loopV);
	DDX_Control(pDX, IDC_CHECK_LOOPNEG, check_loopNeg);
	static_speed = (CStatic*)GetDlgItem(IDC_STATIC_SPEED);
	static_speedX = (CStatic*)GetDlgItem(IDC_STATIC_SPEEDX);
	DDX_Control(pDX, IDC_EDIT_SPEEDH, edit_speedH);
	DDX_Control(pDX, IDC_EDIT_SPEEDV, edit_speedV);
	//
	static_mapSize = (CStatic*)GetDlgItem(IDC_STATIC_MAPSIZE);
	static_mapSizeX = (CStatic*)GetDlgItem(IDC_STATIC_MAPSIZEX);
	DDX_Control(pDX, IDC_EDIT_MAPW, edit_mapW);
	DDX_Control(pDX, IDC_EDIT_MAPH, edit_mapH);
	//ͨ
	DDX_Control(pDX, IDC_EDIT_ORDER, edit_order);
	DDX_Control(pDX, IDC_EDIT_JUMPFRAME, edit_jumpFrame);
	//ɫ
	DDX_Control(pDX, IDC_EDIT_COLOR_R, edit_color_r);
	DDX_Control(pDX, IDC_SLIDER_COLOR_R, slider_color_r);
	DDX_Control(pDX, IDC_EDIT_COLOR_G, edit_color_g);
	DDX_Control(pDX, IDC_SLIDER_COLOR_G, slider_color_g);
	DDX_Control(pDX, IDC_EDIT_COLOR_B, edit_color_b);
	DDX_Control(pDX, IDC_SLIDER_COLOR_B, slider_color_b);
	DDX_Control(pDX, IDC_EDIT_COLOR_A, edit_color_a);
	DDX_Control(pDX, IDC_SLIDER_COLOR_A, slider_color_a);
	DDX_Control(pDX, IDC_EDIT_COLOR_RGBA, edit_color_rgba);
	//
	DDX_Control(pDX, IDC_EDIT_DAYLIGHT, edit_dayLight);
	DDX_Control(pDX, IDC_SLIDER_DAYLIGHT, slider_dayLight);
	DDX_Control(pDX, IDC_EDIT_LIGHT_H, edit_light_h);
	DDX_Control(pDX, IDC_SLIDER_LIGHT_H, slider_light_h);
	DDX_Control(pDX, IDC_EDIT_LIGHT_S, edit_light_s);
	DDX_Control(pDX, IDC_SLIDER_LIGHT_S, slider_light_s);
	DDX_Control(pDX, IDC_EDIT_LIGHT_V, edit_light_v);
	DDX_Control(pDX, IDC_SLIDER_LIGHT_V, slider_light_v);
	DDX_Control(pDX, IDC_EDIT_LIGHT_CONST, edit_light_const);
	DDX_Control(pDX, IDC_SLIDER_LIGHT_CONST, slider_light_const);
	//
	static_png = (CStatic*)GetDlgItem(IDC_STATIC_PNG);
	//Ƽ
	DDX_Control(pDX, IDC_CHECK_CLIPZONE, chech_clipZone);
	DDX_Control(pDX, IDC_EDIT_CLIPUP, edit_clipUp);
	DDX_Control(pDX, IDC_EDIT_CLIPDOWN, edit_clipDown);
	DDX_Control(pDX, IDC_EDIT_CLIPLEFT, edit_clipLeft);
	DDX_Control(pDX, IDC_EDIT_CLIPRIGHT, edit_clipRight);
}

BOOL CNewLayer::OnInitDialog()
{
	CDialog::OnInitDialog();
	//ʼӴ
	picbox.Create(IDD_CMYPICBOX, this);
	CRect rc;
	static_png->GetWindowRect(&rc);
	ScreenToClient(&rc);
	auto dpi = MyGetDPI();
	rc.top += DPISCALE(20);
	picbox.MoveWindow(&rc);
	picbox.ShowWindow(SW_SHOW);
	if (outPxa.GetLength())
	{
		CString pngfile;
		pngfile.Format(L"./data/pxa/%s.png", outPxa.GetString());
		picbox.SetPic(pngfile);
	}
	//õ
	CFileFind finder;
	bool rs = finder.FindFile(L"./data/pxa/*.pxa");
	while (rs)
	{
		rs = finder.FindNextFile();
		CString pxaName = finder.GetFileName();
		CString str = pxaName.Left(pxaName.ReverseFind(L'.'));
		combo_pxa.AddString(str);
	}
	//ÿؼʼֵ
	if (load)
	{
		//ôڱ
		SetWindowText(L"༭ͼ");
		//ͼ
		edit_layerName.SetWindowTextW(outLayerName.GetString());
		if (outPxa.GetLength() > 0)
		{
			auto index = combo_pxa.FindString(0, outPxa.GetString());
			combo_pxa.SetCurSel(index);
		}
	}
	//ͼ
	switch (outLayerType)
	{
	case 0://
		radio_mainLayer.SetCheck(true);
		OnBnClickedRadioMainlayer();
		break;
	case 1://
		radio_bkLayer.SetCheck(true);
		OnBnClickedRadioBklayer();
		break;
	case 2://ѭ
		radio_loopBkLayer.SetCheck(true);
		OnBnClickedRadioLoopbklayer();
		break;
	}
	//ͼ
	CString str;
	if (outOffx == 0)
	{
		str = L"0";
		edit_offx.SetWindowTextW(str.GetString());
	}
	else
	{
		str.Format(L"%f", -outOffx);
		edit_offx.SetWindowTextW(str.GetString());
	}
	if (outOffy == 0)
	{
		str = L"0";
		edit_offy.SetWindowTextW(str.GetString());
	}
	else
	{
		str.Format(L"%f", -outOffy);
		edit_offy.SetWindowTextW(str.GetString());
	}
	str.Format(L"%f", outMyFar);
	edit_far.SetWindowTextW(str.GetString());
	//ѭͼ
	check_loopH.SetCheck(outLoopH);
	check_loopV.SetCheck(outLoopV);
	check_loopNeg.SetCheck(outLoopNeg);
	str.Format(L"%f", outSpeedH);
	edit_speedH.SetWindowTextW(str.GetString());
	str.Format(L"%f", outSpeedV);
	edit_speedV.SetWindowTextW(str.GetString());
	//
	SetDlgItemInt(IDC_EDIT_MAPW, outMapW);
	SetDlgItemInt(IDC_EDIT_MAPH, outMapH);
	//ͨ
	str.Format(L"%f", outOrder);
	edit_order.SetWindowTextW(str.GetString());
	str.Format(L"%d", outJumpFrame);
	edit_jumpFrame.SetWindowTextW(str.GetString());
	//ɫ
	MyRGBA myRGBA;
	myRGBA.Set(outColor);
	slider_color_r.SetRangeMin(0);
	slider_color_r.SetRangeMax(255);
	slider_color_r.SetPos(myRGBA.r);
	slider_color_g.SetRangeMin(0);
	slider_color_g.SetRangeMax(255);
	slider_color_g.SetPos(myRGBA.g);
	slider_color_b.SetRangeMin(0);
	slider_color_b.SetRangeMax(255);
	slider_color_b.SetPos(myRGBA.b);
	slider_color_a.SetRangeMin(0);
	slider_color_a.SetRangeMax(255);
	slider_color_a.SetPos(myRGBA.a);
	//ù
	slider_dayLight.SetRangeMin(0);
	slider_dayLight.SetRangeMax(1000);
	slider_dayLight.SetPos((int)(outDayLight * 1000));
	slider_light_h.SetRangeMin(0);
	slider_light_h.SetRangeMax(1000);
	slider_light_h.SetPos((int)((outHSV[0] + 1) * 500));
	slider_light_s.SetRangeMin(0);
	slider_light_s.SetRangeMax(1000);
	slider_light_s.SetPos((int)((outHSV[1] + 1) * 500));
	slider_light_v.SetRangeMin(0);
	slider_light_v.SetRangeMax(1000);
	slider_light_v.SetPos((int)((outHSV[2] + 1) * 500));
	slider_light_const.SetRangeMin(0);
	slider_light_const.SetRangeMax(1000);
	slider_light_const.SetPos((int)(outLightConst * 1000));
	//ûƼ
	chech_clipZone.SetCheck(outEnableClipZone);
	str.Format(L"%f", outClipZone.top);
	edit_clipUp.SetWindowTextW(str.GetString());
	str.Format(L"%f", outClipZone.bottom);
	edit_clipDown.SetWindowTextW(str.GetString());
	str.Format(L"%f", outClipZone.left);
	edit_clipLeft.SetWindowTextW(str.GetString());
	str.Format(L"%f", outClipZone.right);
	edit_clipRight.SetWindowTextW(str.GetString());
	return 0;
}


void CNewLayer::OnBnClickedOk()
{
	//Ƿд
	CString layerName;
	edit_layerName.GetWindowTextW(layerName);
	if (layerName.GetLength() == 0)
	{
		MessageBoxW(L"дͼ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (!load ||
		(load && outLayerName != layerName))
	{
		auto& pLayerList = pMapSet->layerList;
		if (pLayerList.find(layerName.GetString()) != pLayerList.end())
		{
			CString err;
			err.Format(L"Ѵͼ%s", layerName.GetString());
			MessageBoxW(err.GetString(), L"дϢЧ", MB_ICONINFORMATION);
			return;
		}
	}
	CString pxaStr;
	int index = combo_pxa.GetCurSel();
	if (index < 0)
	{
		MessageBoxW(L"ѡһ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	combo_pxa.GetLBText(index, pxaStr);
	if (pxaStr.GetLength() == 0)
	{
		MessageBoxW(L"δѡ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	outLayerName = layerName;
	outPxa = pxaStr;
	//ͨ
	CString orderStr;
	edit_order.GetWindowTextW(orderStr);
	if (orderStr.GetLength() == 0)
	{
		MessageBoxW(L"˳ֵ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (swscanf_s(orderStr.GetString(), L"%f", &outOrder) == -1)
	{
		MessageBoxW(L"˳ֵȡʧ", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	CString jumpFrameStr;
	edit_jumpFrame.GetWindowTextW(jumpFrameStr);
	if (jumpFrameStr.GetLength() == 0)
	{
		MessageBoxW(L"֡Ծֵ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	outJumpFrame = GetDlgItemInt(IDC_EDIT_JUMPFRAME);
	//ɫ
	CString rgbaStr;
	edit_color_rgba.GetWindowTextW(rgbaStr);
	if (rgbaStr.GetLength() == 0)
	{
		MessageBoxW(L"RGBAȾɫֵ(ʮ)", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	//
	//
	CString dayLightStr;
	edit_dayLight.GetWindowTextW(dayLightStr);
	if (dayLightStr.GetLength() == 0)
	{
		MessageBoxW(L"ֵ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (swscanf_s(dayLightStr.GetString(), L"%f", &outDayLight) == -1)
	{
		MessageBoxW(L"ֵȡʧ", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	//Hɫ
	CString lightHStr;
	edit_light_h.GetWindowTextW(lightHStr);
	if (lightHStr.GetLength() == 0)
	{
		MessageBoxW(L"Hɫֵ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (swscanf_s(lightHStr.GetString(), L"%f", &outHSV[0]) == -1)
	{
		MessageBoxW(L"Hɫֵȡʧ", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	//SͶ
	CString lightSStr;
	edit_light_s.GetWindowTextW(lightSStr);
	if (lightSStr.GetLength() == 0)
	{
		MessageBoxW(L"SͶֵ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (swscanf_s(lightSStr.GetString(), L"%f", &outHSV[1]) == -1)
	{
		MessageBoxW(L"SͶֵȡʧ", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	//V
	CString lightVStr;
	edit_light_v.GetWindowTextW(lightVStr);
	if (lightVStr.GetLength() == 0)
	{
		MessageBoxW(L"Vֵ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (swscanf_s(lightVStr.GetString(), L"%f", &outHSV[2]) == -1)
	{
		MessageBoxW(L"Vֵȡʧ", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	//
	CString lightConstStr;
	edit_light_const.GetWindowTextW(lightConstStr);
	if (lightConstStr.GetLength() == 0)
	{
		MessageBoxW(L"ֵ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	if (swscanf_s(lightConstStr.GetString(), L"%f", &outLightConst) == -1)
	{
		MessageBoxW(L"ֵȡʧ", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	//Ƽ
	CString clipUpStr;
	CString clipDownStr;
	CString clipLeftStr;
	CString clipRightStr;
	clipUpStr.Format(L"%f", outClipZone.top);
	clipDownStr.Format(L"%f", outClipZone.bottom);
	clipLeftStr.Format(L"%f", outClipZone.left);
	clipRightStr.Format(L"%f", outClipZone.right);
	if (chech_clipZone.GetCheck())
	{
		edit_clipUp.GetWindowTextW(clipUpStr);
		if (clipUpStr.GetLength() == 0)
		{
			MessageBoxW(L"Ϸüλ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		edit_clipDown.GetWindowTextW(clipDownStr);
		if (clipDownStr.GetLength() == 0)
		{
			MessageBoxW(L"·üλ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		edit_clipLeft.GetWindowTextW(clipLeftStr);
		if (clipLeftStr.GetLength() == 0)
		{
			MessageBoxW(L"󷽲üλ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		edit_clipRight.GetWindowTextW(clipRightStr);
		if (clipRightStr.GetLength() == 0)
		{
			MessageBoxW(L"ҷüλ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
	}
	outColor = ColorString(rgbaStr.GetString());
	outEnableClipZone = chech_clipZone.GetCheck();
	if (swscanf_s(clipUpStr.GetString(), L"%f", &outClipZone.top) == -1)
	{
		MessageBoxW(L"ϣֵȡʧ", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	if (swscanf_s(clipDownStr.GetString(), L"%f", &outClipZone.bottom) == -1)
	{
		MessageBoxW(L"£ֵȡʧ", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	if (swscanf_s(clipLeftStr.GetString(), L"%f", &outClipZone.left) == -1)
	{
		MessageBoxW(L"ֵȡʧ", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	if (swscanf_s(clipRightStr.GetString(), L"%f", &outClipZone.right) == -1)
	{
		MessageBoxW(L"ңֵȡʧ", L"дϢ", MB_ICONINFORMATION);
		return;
	}
	//ͼ
	if (radio_mainLayer.GetCheck())
	{
		//Լ
		CString mapWStr;
		edit_mapW.GetWindowTextW(mapWStr);
		if (mapWStr.GetLength() == 0)
		{
			MessageBoxW(L"ͼ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		CString mapHStr;
		edit_mapH.GetWindowTextW(mapHStr);
		if (mapHStr.GetLength() == 0)
		{
			MessageBoxW(L"ͼ߶", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		outMapW = GetDlgItemInt(IDC_EDIT_MAPW);
		outMapH = GetDlgItemInt(IDC_EDIT_MAPH);
		outLayerType = 0;
	}
	else if (radio_bkLayer.GetCheck())
	{
		//Լ
		CString offxStr;
		edit_offx.GetWindowTextW(offxStr);
		if (offxStr.GetLength() == 0)
		{
			MessageBoxW(L"xƫֵ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		CString offyStr;
		edit_offy.GetWindowTextW(offyStr);
		if (offyStr.GetLength() == 0)
		{
			MessageBoxW(L"yƫֵ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		CString farStr;
		edit_far.GetWindowTextW(farStr);
		if (farStr.GetLength() == 0)
		{
			MessageBoxW(L"farֵ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		float tempOffx, tempOffy;
		if (swscanf_s(offxStr.GetString(), L"%f", &tempOffx) == -1)
		{
			MessageBoxW(L"Xƫֵȡʧ", L"дϢ", MB_ICONINFORMATION);
			return;
		}
		if (swscanf_s(offyStr.GetString(), L"%f", &tempOffy) == -1)
		{
			MessageBoxW(L"Yƫֵȡʧ", L"дϢ", MB_ICONINFORMATION);
			return;
		}
		if (swscanf_s(farStr.GetString(), L"%f", &outMyFar) == -1)
		{
			MessageBoxW(L"͸Ӹƶzֵȡʧ", L"дϢ", MB_ICONINFORMATION);
			return;
		}
		outOffx = -tempOffx;
		outOffy = -tempOffy;
		outLayerType = 1;
	}
	else if (radio_loopBkLayer.GetCheck())
	{
		//ѭԼ
		CString speedHStr;
		edit_speedH.GetWindowTextW(speedHStr);
		if (speedHStr.GetLength() == 0)
		{
			MessageBoxW(L"ˮƽƽٶ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		CString speedVStr;
		edit_speedV.GetWindowTextW(speedVStr);
		if (speedVStr.GetLength() == 0)
		{
			MessageBoxW(L"봹ֱƽٶ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		CString farStr;
		edit_far.GetWindowTextW(farStr);
		if (farStr.GetLength() == 0)
		{
			MessageBoxW(L"farֵ", L"дϢδ", MB_ICONINFORMATION);
			return;
		}
		if (swscanf_s(speedHStr.GetString(), L"%f", &outSpeedH) == -1)
		{
			MessageBoxW(L"ˮƽѭٶֵȡʧ", L"дϢ", MB_ICONINFORMATION);
			return;
		}
		if (swscanf_s(speedVStr.GetString(), L"%f", &outSpeedV) == -1)
		{
			MessageBoxW(L"ֱѭٶֵȡʧ", L"дϢ", MB_ICONINFORMATION);
			return;
		}
		if (swscanf_s(farStr.GetString(), L"%f", &outMyFar) == -1)
		{
			MessageBoxW(L"͸Ӹƶzֵȡʧ", L"дϢ", MB_ICONINFORMATION);
			return;
		}
		outLoopH = check_loopH.GetCheck();
		outLoopV = check_loopV.GetCheck();
		outLoopNeg = check_loopNeg.GetCheck();
		outLayerType = 2;
	}
	else
	{
		MessageBoxW(L"δѡͼ", L"дϢδ", MB_ICONINFORMATION);
		return;
	}
	CDialog::OnOK();
}


void CNewLayer::OnBnClickedRadioMainlayer()
{
	//л
	static_offx->ShowWindow(SW_HIDE);
	static_offy->ShowWindow(SW_HIDE);
	edit_offx.ShowWindow(SW_HIDE);
	edit_offy.ShowWindow(SW_HIDE);
	static_far->ShowWindow(SW_HIDE);
	edit_far.ShowWindow(SW_HIDE);
	//ѭ
	check_loopH.ShowWindow(SW_HIDE);
	check_loopV.ShowWindow(SW_HIDE);
	check_loopNeg.ShowWindow(SW_HIDE);
	static_speed->ShowWindow(SW_HIDE);
	static_speedX->ShowWindow(SW_HIDE);
	edit_speedH.ShowWindow(SW_HIDE);
	edit_speedV.ShowWindow(SW_HIDE);
	//
	static_mapSize->ShowWindow(SW_SHOW);
	static_mapSizeX->ShowWindow(SW_SHOW);
	edit_mapW.ShowWindow(SW_SHOW);
	edit_mapH.ShowWindow(SW_SHOW);
}


void CNewLayer::OnBnClickedRadioBklayer()
{
	//л
	static_offx->ShowWindow(SW_SHOW);
	static_offy->ShowWindow(SW_SHOW);
	edit_offx.ShowWindow(SW_SHOW);
	edit_offy.ShowWindow(SW_SHOW);
	static_far->ShowWindow(SW_SHOW);
	edit_far.ShowWindow(SW_SHOW);
	//ѭ
	check_loopH.ShowWindow(SW_HIDE);
	check_loopV.ShowWindow(SW_HIDE);
	check_loopNeg.ShowWindow(SW_HIDE);
	static_speed->ShowWindow(SW_HIDE);
	static_speedX->ShowWindow(SW_HIDE);
	edit_speedH.ShowWindow(SW_HIDE);
	edit_speedV.ShowWindow(SW_HIDE);
	//
	static_mapSize->ShowWindow(SW_HIDE);
	static_mapSizeX->ShowWindow(SW_HIDE);
	edit_mapW.ShowWindow(SW_HIDE);
	edit_mapH.ShowWindow(SW_HIDE);
}


void CNewLayer::OnBnClickedRadioLoopbklayer()
{
	//л
	static_offx->ShowWindow(SW_HIDE);
	static_offy->ShowWindow(SW_HIDE);
	edit_offx.ShowWindow(SW_HIDE);
	edit_offy.ShowWindow(SW_HIDE);
	static_far->ShowWindow(SW_SHOW);//
	edit_far.ShowWindow(SW_SHOW);
	//ѭ
	check_loopH.ShowWindow(SW_SHOW);
	check_loopV.ShowWindow(SW_SHOW);
	check_loopNeg.ShowWindow(SW_SHOW);
	static_speed->ShowWindow(SW_SHOW);
	static_speedX->ShowWindow(SW_SHOW);
	edit_speedH.ShowWindow(SW_SHOW);
	edit_speedV.ShowWindow(SW_SHOW);
	//
	static_mapSize->ShowWindow(SW_HIDE);
	static_mapSizeX->ShowWindow(SW_HIDE);
	edit_mapW.ShowWindow(SW_HIDE);
	edit_mapH.ShowWindow(SW_HIDE);
}


void CNewLayer::OnCbnSelchangeComboPxa()
{
	CString pxaName;
	int index = combo_pxa.GetCurSel();
	if (index < 0)
		return;
	combo_pxa.GetLBText(index, pxaName);
	if (pxaName.GetLength() == 0)
		return;
	CString pngfile;
	pngfile.Format(L"./data/pxa/%s.png", pxaName.GetString());
	picbox.SetPic(pngfile);
}


void CNewLayer::OnEnChangeEditColorR()
{
	if (inRGBAEdit)
		return;
	int tempColorR = 0xff;
	CString colorR;
	edit_color_r.GetWindowTextW(colorR);
	if (colorR.GetLength() == 0)
		return;
	if (swscanf_s(colorR.GetString(), L"%d", &tempColorR) == -1)
		return;
	slider_color_r.SetPos(tempColorR);
	UpdateRGBACEdit();
}


void CNewLayer::OnNMCustomdrawSliderColorR(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	*pResult = 0;
	if (inRGBAEdit)
		return;
	// TODO: ڴӿؼ֪ͨ
	int pos = slider_color_r.GetPos();
	CString str;
	str.Format(L"%d", pos);
	edit_color_r.SetWindowTextW(str.GetString());
	UpdateRGBACEdit();
}


void CNewLayer::OnEnChangeEditColorG()
{
	if (inRGBAEdit)
		return;
	int tempColorG = 0xff;
	CString colorG;
	edit_color_g.GetWindowTextW(colorG);
	if (colorG.GetLength() == 0)
		return;
	if (swscanf_s(colorG.GetString(), L"%d", &tempColorG) == -1)
		return;
	slider_color_g.SetPos(tempColorG);
	UpdateRGBACEdit();
}


void CNewLayer::OnNMCustomdrawSliderColorG(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	*pResult = 0;
	if (inRGBAEdit)
		return;
	// TODO: ڴӿؼ֪ͨ
	int pos = slider_color_g.GetPos();
	CString str;
	str.Format(L"%d", pos);
	edit_color_g.SetWindowTextW(str.GetString());
	UpdateRGBACEdit();
}


void CNewLayer::OnEnChangeEditColorB()
{
	if (inRGBAEdit)
		return;
	int tempColorB = 0xff;
	CString colorB;
	edit_color_b.GetWindowTextW(colorB);
	if (colorB.GetLength() == 0)
		return;
	if (swscanf_s(colorB.GetString(), L"%d", &tempColorB) == -1)
		return;
	slider_color_b.SetPos(tempColorB);
	UpdateRGBACEdit();
}


void CNewLayer::OnNMCustomdrawSliderColorB(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	*pResult = 0;
	if (inRGBAEdit)
		return;
	// TODO: ڴӿؼ֪ͨ
	int pos = slider_color_b.GetPos();
	CString str;
	str.Format(L"%d", pos);
	edit_color_b.SetWindowTextW(str.GetString());
	UpdateRGBACEdit();
}


void CNewLayer::OnEnChangeEditColorA()
{
	if (inRGBAEdit)
		return;
	int tempColorA = 0xff;
	CString colorA;
	edit_color_a.GetWindowTextW(colorA);
	if (colorA.GetLength() == 0)
		return;
	if (swscanf_s(colorA.GetString(), L"%d", &tempColorA) == -1)
		return;
	slider_color_a.SetPos(tempColorA);
	UpdateRGBACEdit();
}


void CNewLayer::OnNMCustomdrawSliderColorA(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	*pResult = 0;
	if (inRGBAEdit)
		return;
	// TODO: ڴӿؼ֪ͨ
	int pos = slider_color_a.GetPos();
	CString str;
	str.Format(L"%d", pos);
	edit_color_a.SetWindowTextW(str.GetString());
	UpdateRGBACEdit();
}


void CNewLayer::OnEnChangeEditColorRgba()
{
	if (inSingleRGBAEdit)
		return;
	DWORD tempColorRGBA = 0xffffffff;
	CString colorRGBA;
	edit_color_rgba.GetWindowTextW(colorRGBA);
	if (colorRGBA.GetLength() == 0)
		return;
	//ȡRGBAֵ
	CString strR, strG, strB, strA;
	DWORD r = 0, g = 0, b = 0, a = 0;
	if (colorRGBA.GetLength() > 1)//RR
	{
		strR.Append(colorRGBA.Left(2).GetString());
		if (swscanf_s(strR.GetString(), L"%x", &r) == -1)
			return;
	}
	else if(colorRGBA.GetLength() == 1)//R
	{
		strR.Append(colorRGBA.Left(1).GetString());
		strR.Append(L"0");
		if (swscanf_s(strR.GetString(), L"%x", &r) == -1)
			return;
	}
	if (colorRGBA.GetLength() > 3)//RR GG
	{
		strG.Append(colorRGBA.Left(4).Right(2).GetString());
		if (swscanf_s(strG.GetString(), L"%x", &g) == -1)
			return;
	}
	else if(colorRGBA.GetLength() == 3)//RR G
	{
		strG.Append(colorRGBA.Right(1).GetString());
		strG.Append(L"0");
		if (swscanf_s(strG.GetString(), L"%x", &g) == -1)
			return;
	}
	if (colorRGBA.GetLength() > 5)//RR GG BB
	{
		strB.Append(colorRGBA.Left(6).Right(2).GetString());
		if (swscanf_s(strB.GetString(), L"%x", &b) == -1)
			return;
	}
	else if (colorRGBA.GetLength() == 5)//RR GG B
	{
		strB.Append(colorRGBA.Right(1).GetString());
		strB.Append(L"0");
		if (swscanf_s(strB.GetString(), L"%x", &b) == -1)
			return;
	}
	if (colorRGBA.GetLength() > 7)//RR GG BB AA
	{
		strA.Append(colorRGBA.Left(8).Right(2).GetString());
		if (swscanf_s(strA.GetString(), L"%x", &a) == -1)
			return;
	}
	else if (colorRGBA.GetLength() == 7)
	{
		strA.Append(colorRGBA.Right(1).GetString());
		strA.Append(L"0");
		if (swscanf_s(strA.GetString(), L"%x", &a) == -1)
			return;
	}
	inRGBAEdit = true;
	slider_color_r.SetPos(r);
	slider_color_g.SetPos(g);
	slider_color_b.SetPos(b);
	slider_color_a.SetPos(a);
	CString val;
	val.Format(L"%d", r);
	edit_color_r.SetWindowTextW(val.GetString());
	val.Format(L"%d", g);
	edit_color_g.SetWindowTextW(val.GetString());
	val.Format(L"%d", b);
	edit_color_b.SetWindowTextW(val.GetString());
	val.Format(L"%d", a);
	edit_color_a.SetWindowTextW(val.GetString());
	inRGBAEdit = false;
	if (pDrawWnd)
	{
		pLayer->color = RGBA(r, g, b, a);
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}


void CNewLayer::OnEnChangeEditDaylight()
{
	float tempDayLight = 1.0f;
	CString dayLight;
	edit_dayLight.GetWindowTextW(dayLight);
	if (dayLight.GetLength() == 0)
		return;
	if (swscanf_s(dayLight.GetString(), L"%f", &tempDayLight) == -1)
		return;
	slider_dayLight.SetPos((int)(tempDayLight * 1000));
	if (pDrawWnd)
	{
		pLayer->dayLight = tempDayLight;
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}


void CNewLayer::OnNMCustomdrawSliderDaylight(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: ڴӿؼ֪ͨ
	int pos = slider_dayLight.GetPos();
	float val = (float)pos / 1000.0f;
	CString str;
	str.Format(L"%f", val);
	edit_dayLight.SetWindowTextW(str.GetString());
	*pResult = 0;
	if (pDrawWnd)
	{
		pLayer->dayLight = val;
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}


void CNewLayer::OnEnChangeEditLightH()
{
	float tempLightH = 0;
	CString lightH;
	edit_light_h.GetWindowTextW(lightH);
	if (lightH.GetLength() == 0)
		return;
	if (swscanf_s(lightH.GetString(), L"%f", &tempLightH) == -1)
		return;
	slider_light_h.SetPos((int)((tempLightH + 1) * 500));
	if (pDrawWnd)
	{
		pLayer->tinyHSV[0] = tempLightH;
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}


void CNewLayer::OnNMCustomdrawSliderLightH(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: ڴӿؼ֪ͨ
	int pos = slider_light_h.GetPos();
	float val = ((float)pos / 500.0f - 1);
	CString str;
	str.Format(L"%f", val);
	edit_light_h.SetWindowTextW(str.GetString());
	*pResult = 0;
	if (pDrawWnd)
	{
		pLayer->tinyHSV[0] = val;
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}


void CNewLayer::OnEnChangeEditLightS()
{
	float tempLightS = 0;
	CString lightS;
	edit_light_s.GetWindowTextW(lightS);
	if (lightS.GetLength() == 0)
		return;
	if (swscanf_s(lightS.GetString(), L"%f", &tempLightS) == -1)
		return;
	slider_light_s.SetPos((int)((tempLightS + 1) * 500));
	if (pDrawWnd)
	{
		pLayer->tinyHSV[1] = tempLightS;
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}


void CNewLayer::OnNMCustomdrawSliderLightS(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: ڴӿؼ֪ͨ
	int pos = slider_light_s.GetPos();
	float val = ((float)pos / 500.0f - 1);
	CString str;
	str.Format(L"%f", val);
	edit_light_s.SetWindowTextW(str.GetString());
	*pResult = 0;
	if (pDrawWnd)
	{
		pLayer->tinyHSV[1] = val;
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}


void CNewLayer::OnEnChangeEditLightV()
{
	float tempLightV = 0;
	CString lightV;
	edit_light_v.GetWindowTextW(lightV);
	if (lightV.GetLength() == 0)
		return;
	if (swscanf_s(lightV.GetString(), L"%f", &tempLightV) == -1)
		return;
	slider_light_v.SetPos((int)((tempLightV + 1) * 500));
	if (pDrawWnd)
	{
		pLayer->tinyHSV[2] = tempLightV;
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}


void CNewLayer::OnNMCustomdrawSliderLightV(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: ڴӿؼ֪ͨ
	int pos = slider_light_v.GetPos();
	float val = ((float)pos / 500.0f - 1);
	CString str;
	str.Format(L"%f", val);
	edit_light_v.SetWindowTextW(str.GetString());
	*pResult = 0;
	if (pDrawWnd)
	{
		pLayer->tinyHSV[2] = val;
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}


void CNewLayer::OnEnChangeEditLightConst()
{
	float tempLightConst = 0;
	CString lightConst;
	edit_light_const.GetWindowTextW(lightConst);
	if (lightConst.GetLength() == 0)
		return;
	if (swscanf_s(lightConst.GetString(), L"%f", &tempLightConst) == -1)
		return;
	slider_light_const.SetPos((int)(tempLightConst * 1000));
	if (pDrawWnd)
	{
		pLayer->lightConst = tempLightConst;
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}


void CNewLayer::OnNMCustomdrawSliderLightConst(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: ڴӿؼ֪ͨ
	int pos = slider_light_const.GetPos();
	float val = (float)pos / 1000.0f;
	CString str;
	str.Format(L"%f", val);
	edit_light_const.SetWindowTextW(str.GetString());
	*pResult = 0;
	if (pDrawWnd)
	{
		pLayer->lightConst = val;
		((CMapEditorDraw*)pDrawWnd)->Draw();
	}
}
