#pragma once
#include "global.h"
#include "MyStructDef.h"
#include "CPxaEditor.h"
#include "EntityRes.h"
class CMapEditorDraw : public CDialog
{
	DECLARE_DYNAMIC(CMapEditorDraw)
	DECLARE_MESSAGE_MAP()
public:
	CMapEditorDraw(CWnd* pParent = nullptr);   // ׼캯
	virtual ~CMapEditorDraw();
	// Ի
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_CMAPEDITOR_DRAW };
#endif
	void* pParentEditor = nullptr;
	MyView* pBrushView = nullptr;
	int* pTimeCounter = nullptr;
	float* pWindAniIndex = nullptr;
	float* pWindAniIndex2 = nullptr;
	int* pMapW = nullptr;
	int* pMapH = nullptr;
	float* pWallShadow = nullptr;
	float* pStageLight = nullptr;
	std::wstring* pVS = nullptr;
	std::wstring* pPS = nullptr;
	std::list<MyMapLayer*>* pDrawLayer = nullptr;//Ҫʵı
	std::mutex* pMtx = nullptr;
	bool* pPlaying = nullptr;
	//ʵ༭
	bool* pDragEntity = nullptr;
	//¼ϵͳ
	int* pRecordEndPos_x = 0, *pRecordEndPos_y = 0;
	MyView* GetMyView();
	void Draw(bool timeCounterDraw = false);
	void ResetContext();
	void RefreshImage();
	void ResetEntityPlay();
	void SetCursorToCopyBuffSize();
	EntityRes* GetEntityRes();
	void GetCopyBoard(CMAPEDITOR_DATATYPE_PXM** outCopyBuff, int** outCopyBuff_w, int** outCopyBuff_h);
	void UpdateMapCache();
	PxaData* GetPxa(CString pxaName);
	void SetScreenShot();
	std::wstring GenerateFileName(const wchar_t* layerName, bool bStageOrEntity, bool fBkOrbBk) const;
	void MergePNGsWithAseprite(const std::wstring& asepritePath,
		const std::wstring& luaScriptPath,
		const std::wstring& outputAsepriteFile,
		const std::vector<std::wstring>& pngFiles);
protected:
	void DoDataExchange(CDataExchange* pDX) override;
	BOOL OnInitDialog() override;
public:
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
private:
	//Ⱦ
	MyDX11Renderer pRenderer;
	TTF_Font* pFont_sourcesun20 = nullptr;//
	std::unordered_map<wchar_t, MyFontData> pFontMap28;
	MyView view;
	//ͼ
	std::unordered_map<std::wstring, MyTextureAndSRV> loadedTexture;
	std::unordered_map<std::wstring, PxaData> loadedPxa;
	MyTextureAndSRV tas_pxatype;
	MyTextureAndSRV tas_nullpxa;
	ID3D11ShaderResourceView* GetTexture(CString pngName);
	bool painting = false;//ڻ
	int paintStartCursorPosX = 0, paintStartCursorPosY = 0;//Ϳģʽ
	CMAPEDITOR_DATATYPE_PXM copyBuff;//
	int copyBuff_w = 0, copyBuff_h = 0;//
	//ʵ༭
	CPoint rclick_last_pt;
	//ʵ岥
	EntityRes entityRes;
	void DrawTile();//Ϳ
	void DrawLayerBack(MyMapLayer* pLayer);//
	void DrawLayerFront(MyMapLayer* pLayer);//Ʊ
	void DrawLoopLayer(MyMapLayer* pLayer, MyMapLayer* selectLayer);//ѭ
	void DrawPxa(MyMapLayer* pLayer);
	bool IsBackPxa(int pxaID);
	bool IsWindPxa(int pxaID);
	void DrawEntityGrid(MyMapLayer* pLayer);//ʵ
	void DrawEntityLabel(MyMapLayer* pLayer);//ʵǩ
	void DrawClipRect(MyMapLayer* pLayer);//Ƽ
	void DrawStage(bool timeCounterDraw, MyMapLayer* selectLayer);
	//
	ExTextureBuffer stageBuffer, entityLight;
	void DrawRecordGoal();
	//
	CString snapshot_aseApp;
	CString snapshot_saveAs;
	CString snapshot_path;
};
