#include "CMCPosTable.h"
#include "resource.h"
#include "CMainEditor.h"
#include "COSLabel.h"
#include "CMCEditor.h"

IMPLEMENT_DYNAMIC(CMCPosTable, CDialog)

BEGIN_MESSAGE_MAP(CMCPosTable, CDialog)
	ON_COMMAND(IDOK, &CMCPosTable::OnEnterKey)
	ON_WM_SIZE()
	ON_COMMAND(ID_ADD_LABEL, &CMCPosTable::OnAddLabel)
	ON_COMMAND(ID_RENAME_LABEL, &CMCPosTable::OnRenameLabel)
	ON_COMMAND(ID_DELETE_LABEL, &CMCPosTable::OnDeleteLabel)
	ON_WM_SHOWWINDOW()
END_MESSAGE_MAP()

CMCPosTable::CMCPosTable(CWnd* pParent)
	: CDialog(IDD_CMCPOS_TABLE, pParent)
{
}

CMCPosTable::~CMCPosTable()
{
}

void CMCPosTable::UpdateContext()
{
	list_mcchar.ResetContent();
	auto mainEditor = (CMainEditor*)pMainEditor;
	std::vector<CString> labelList;
	mainEditor->GetDBField_List(&labelList, DBTABLENAME_MYCHAR_POSITION, L"mcpos");
	for (auto& p : labelList)
		list_mcchar.AddString(p);
}

void CMCPosTable::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	groupbox_mcchar = (CStatic*)GetDlgItem(IDC_STATIC_MCPOS);
	DDX_Control(pDX, IDC_LIST_MCPOS, list_mcchar);
	groupbox_same = (CStatic*)GetDlgItem(IDC_STATIC_MCPOS_SAME);
	DDX_Control(pDX, IDC_LIST_MCPOS_SAME, list_same);
}

BOOL CMCPosTable::OnInitDialog()
{
	CDialog::OnInitDialog();
	//Ӧóͼ
	auto hIcon = AfxGetApp()->LoadIcon(IDI_APPICON_TABLE);
	SetIcon(hIcon, true);
	//ÿؼ
	list_mcchar.SetMenu(IDR_CMCPREP_RMENU, IDR_CMCPREP_RMENU_NOSEL);
	return 0;
}

void CMCPosTable::OnCancel()
{
	ShowWindow(SW_HIDE);
}

void CMCPosTable::OnEnterKey()
{
}

void CMCPosTable::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	
	if (!groupbox_mcchar)
		return;
	int dx = 20;
	int dy = 20;
	int c = 36;
	groupbox_mcchar->MoveWindow(dx, dy, cx / 2 - dx - dx / 2, cy - dy * 2);
	list_mcchar.MoveWindow(dx, dy + c, cx / 2 - dx - dx / 2, cy - dy * 2 - c);
	groupbox_same->MoveWindow(dx / 2 + cx / 2, dy, cx / 2 - dx - dx / 2, cy - dy * 2);
	list_same.MoveWindow(dx / 2 + cx / 2, dy + c, cx / 2 - dx - dx / 2, cy - dy * 2 - c);

}

void CMCPosTable::OnAddLabel()
{
	
	//ӱǩ
	COSLabel dlg;
	dlg.SetWindowTitleAndLabel(L"ӽɫλǩ", L"ǩ");
	if (dlg.DoModal() != IDOK)
		return;
	//ݿӱǩ
	auto mainEditor = (CMainEditor*)pMainEditor;
	mainEditor->SetDBField(DBTABLENAME_MYCHAR_POSITION, L"mcpos", L"", dlg.outLabel);
	UpdateContext();
}


void CMCPosTable::OnRenameLabel()
{
	
	//ǩ
	int index = list_mcchar.GetCurSel();
	CString mcposStr;
	list_mcchar.GetText(index, mcposStr);

	COSLabel dlg;
	dlg.outLabel = mcposStr;
	dlg.load = true;
	dlg.SetWindowTitleAndLabel(L"ɫλǩ", L"ǩ");
	if (dlg.DoModal() != IDOK)
		return;
	if (mcposStr == dlg.outLabel)
		return;
	//±ǩ
	auto mainEditor = (CMainEditor*)pMainEditor;
	mainEditor->SetDBField(DBTABLENAME_MYCHAR_POSITION, L"mcpos", mcposStr, dlg.outLabel);
	UpdateContext();
}


void CMCPosTable::OnDeleteLabel()
{
	
	//ɾǩ
	int index = list_mcchar.GetCurSel();
	CString mcposStr;
	list_mcchar.GetText(index, mcposStr);

	auto mainEditor = (CMainEditor*)pMainEditor;
	mainEditor->DelDBField(DBTABLENAME_MYCHAR_POSITION, L"mcpos", mcposStr);
	UpdateContext();
}


void CMCPosTable::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	auto parentWindow = (CMCEditor*)pParentWindow;
	if (bShow)
		parentWindow->GetMenu()->GetSubMenu(CMCEDITOR_MENUINDEX_WINDOW)->CheckMenuItem(ID_MCPOS_TABLE, MF_BYCOMMAND | MF_CHECKED);
	else
		parentWindow->GetMenu()->GetSubMenu(CMCEDITOR_MENUINDEX_WINDOW)->CheckMenuItem(ID_MCPOS_TABLE, MF_BYCOMMAND | MF_UNCHECKED);
}
