#include "PeSmog.h"

PeSmog::PeSmog()
{
	type = 3;
	ani.png = L"pe_effect_obj";
	ani.sprite_index = L"smog";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	action_timecounter = action_timecounter_max = 24;
}

void PeSmog::Step()
{
	if (ani.image_index == 4)
		Destroy();
	color = RGBA(0xff, 0xff, 0xff, (UINT8)(0xff * action_timecounter / action_timecounter_max));
	//
	vx /= 1.1f;
	vy /= 1.1f;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (action_timecounter > 0)
		action_timecounter--;
}

std::shared_ptr<Entity> CreatePeSmog()
{
	return std::make_shared<PeSmog>();
}

void SetPeSmog(std::shared_ptr<Entity> parent, float x, float y, int nMin, int nMax, float angle)
{
	int num = Random(nMin, nMax);
	for (size_t i = 0; i < num; i++)
	{
		float finallyAngle = angle + Random(-45, 45);
		float strength = (Random(0, 5) * 0x100 + 0x200) / ts;
		auto e = std::make_shared<PeSmog>();
		e->x = x;
		e->y = y;
		e->vx = strength * cosf(finallyAngle * deg2rad);
		e->vy = strength * sinf(finallyAngle * deg2rad);
		parent->gameFunc->SetEntity(parent, e);
	}
}

void SetPeSmogClimb(std::shared_ptr<Entity> parent, float x, float y, int nMin, int nMax, float angle)
{
	int num = Random(nMin, nMax);
	for (size_t i = 0; i < num; i++)
	{
		float finallyAngle = angle + Random(-45, 45);
		float strength = (Random(0, 5) * 0x100 + 0x200) / ts;
		auto e = std::make_shared<PeSmog>();
		e->x = x;
		e->y = y;
		e->vx = strength * cosf(finallyAngle * deg2rad);
		e->vy = strength * sinf(finallyAngle * deg2rad);
		e->drawBeforeOtherEntity = true;
		e->ani.sprite_index = L"smog_climb";
		parent->gameFunc->SetEntity(parent, e);
	}
}

void SetPeSmog(std::shared_ptr<Entity> parent, float x, float y, int num)
{
	for (size_t i = 0; i < num; i++)
	{
		int offset_x = Random((int)-parent->cbRect.left, (int)parent->cbRect.right);
		int offset_y = Random((int)-parent->cbRect.top, (int)parent->cbRect.bottom);
		auto e = std::make_shared<PeSmog>();
		e->x = x + offset_x;
		e->y = y + offset_y;
		auto vec = XMVector2Normalize(XMVectorSet((float)offset_x, (float)offset_y, 0, 0));
		float strength = (Random(0, 5) * 0x100 + 0x200) / ts;
		e->vx = strength * XMVectorGetX(vec);
		e->vy = strength * XMVectorGetY(vec);
		parent->gameFunc->SetEntity(parent, e);
	}
}
