#include "CS_SlippersAtk.h"
#include "PeSmog.h"
CS_SlippersAtk::CS_SlippersAtk()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_slippers_atk";
	vx = 0x800 / ts;
	cbRect.left = cbRect.right = 3;
	cbRect.top = cbRect.bottom = 3;
}

void CS_SlippersAtk::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_SlippersAtk::Step()
{
	//ִ˶
	Entity::Step();
	switch (stateID)
	{
	case 1:
		stateGravity.State();
		if (cbRect.cbBottom)
		{
			SetPeSmog(shared_from_this(), x, y, 1, 1, 135);
			stateID = 2;
		}
		ani.sprite_index = L"ls_slippers_rotate";
		//ִײ
		Entity::Collision();
		break;
	case 2:
		if (abs(vx) > 0.001f)
			vx /= 1.05f;
		ani.sprite_index = L"ls_slippers_drop";
		//ִײ
		Entity::Collision();
		break;
	}
}

void CS_SlippersAtk::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	switch (stateID)
	{
	case 0:
		ani.sprite_index = L"ls_slippers_atk";
		break;
	case 1:
		cbRect.enableCbRect = true;
		cbRect.enableSoild = true;
		vy = -0x200 / ts;
		vx = -0x100 / ts;
		stateGravity.SetGravityScale(0.5f);
		ani.sprite_index = L"ls_slippers_rotate";
		break;
	}
}

void CS_SlippersAtk::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"hit")
		SetState(1, lr);
}

std::shared_ptr<Entity> CreateCS_SlippersAtk()
{
	return std::make_shared<CS_SlippersAtk>();
}
