#include "CS_SeaVillageAni.h"

CS_SeaVillageAni::CS_SeaVillageAni()
{
	ani.png = L"CS_CaveStoryMod";
	for (int i = 0; i < 5; i++)
		ani.hideLayerList.insert(i);
}

void CS_SeaVillageAni::Step()
{
	//
	if (gameFunc->GetPlayerDistanceWithLineTest)
	{
		auto wplayer = gameFunc->GetPlayerDistanceWithLineTest(gameFunc->game, x, y).lock();
		if (wplayer)
		{
			lr = wplayer->x > x;
		}
	}
	ani.sprite_index = lr == 0 ? L"mc_seavillager_l" : L"mc_seavillager_r";
}

void CS_SeaVillageAni::SetState(int stateID, int lr)
{
	ani.sprite_index = lr == 0 ? L"mc_seavillager_l" : L"mc_seavillager_r";
	for (int i = 0; i < 5; i++)
		ani.hideLayerList.insert(i);
	if (el.arg.length() > 0)
	{
		try
		{
			int index = std::stoi(el.arg);
			ani.hideLayerList.erase(index);
		}
		catch (const std::exception&)
		{
			ani.hideLayerList.erase(0);
		}
	}
	else
	{
		ani.hideLayerList.erase(0);
	}
}

std::shared_ptr<Entity> CreateCS_SeaVillage()
{
	return std::make_shared<CS_SeaVillageAni>();
}
