#include "CS_QuoteSuperMissileBladeExplode.h"
#include "CS_PeSmoke.h"
#include "CS_PeFlash.h"
CS_QuoteSuperMissileBladeExplode::CS_QuoteSuperMissileBladeExplode(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.left = 12;
	cbRect.right = 12;
	cbRect.top = 12;
	cbRect.bottom = 12;
	ani.png = L"CS_CaveStoryMod";
	//
	damaged_limit = 100;
	damage_reset_counter = 1;
}

void CS_QuoteSuperMissileBladeExplode::Init(std::weak_ptr<Entity> self)
{
	gameFunc->PlaySound(L"CS_044_missile_hit");
	Entity::Init(self);
}

void CS_QuoteSuperMissileBladeExplode::Step()
{
	if (act_wait % 3 == 0)
	{
		float dx = (float)Random(-40, 40);
		float dy = (float)Random(-40, 40);
		for (size_t i = 0; i < 2; i++)
		{
			float offset_x = Random((int)-cbRect.left, (int)cbRect.right) + dx;
			float offset_y = Random((int)-cbRect.top, (int)cbRect.bottom) + dy;
			auto e = std::make_shared<CS_PeSmoke>();
			e->x = x + offset_x;
			e->y = y + offset_y;
			e->style = 1;
			gameFunc->SetEntity(shared_from_this(), e);
		}
		//Ч
		SetCS_PeFlash(shared_from_this(), x + dx, y + dy);
	}
	if (--act_wait < 0)
		Destroy();
}

void CS_QuoteSuperMissileBladeExplode::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 2;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 3;//ǹ
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}
