#include "CS_QuoteSuperMissile.h"
#include "CS_Quote.h"
#include "CS_PeOutOfAmmo.h"
const int CS_QUOTESTATENAME_SUPERMISSILE = GetNextEntityStateID();
CS_QuoteSuperMissile::CS_QuoteSuperMissile()
{
	stateID = CS_QUOTESTATENAME_SUPERMISSILE;
	cd_counter = 0;
	cd_counter_max = 1;
	iconIndex = 1;
	mp_cost = 5;
}

const wchar_t* CS_QuoteSuperMissile::GetSaveName()
{
	return L"Missile";
}

const wchar_t* CS_QuoteSuperMissile::GetFuncName()
{
	return L"QuoteSkill_SuperMissile";
}

const wchar_t* CS_QuoteSuperMissile::GetCheckFuncName()
{
	return L"QuoteSkill_SuperMissile_Check";
}

void CS_QuoteSuperMissile::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	bUIShowDisableSkill = !(
		mychar->lastGun != this &&
		!lock
		);
	bool a1 = mychar->lastGun != this &&
		!lock;
	bool b1 = (mychar->input.key & keyMask);

	bool a = a1;
	bool b = b1;
	if (a && b)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//޼ȴʱ
	EntitySkillState::SubStep();
	//ӵľЧʱ
	if (outOfAmmo_counter > 0)
		outOfAmmo_counter--;
}

void CS_QuoteSuperMissile::ChangeStateMsg(int stateID)
{
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	if (stateID == GetStateID())
	{
		//ʼ
		enable = true;
		//лǹ
		mychar->lastGun = this;
		we->gameFunc->PlaySound(L"CS_004_switchweapon");
	}
	else if (stateID == CS_QuoteSTATENAME_FIRE && amList.size() <= 3 &&
		mychar->lastGun == this)
	{
		//ʼ
		enable = false;
		if (we->mp >= mp_cost)
		{
			//
			we->mp -= mp_cost;
			//
			we->gameFunc->PlaySound(L"CS_037_gun_click");
			if (we->ud == 0)
			{
				if (we->lr == 0)
				{
					amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x - 6, we->y + 1));
					amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x, we->y - 8));
					amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x + 4, we->y - 1));
				}
				else
				{
					amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x + 6, we->y + 1));
					amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x, we->y - 8));
					amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x - 4, we->y - 1));
				}
			}
			else
			{
				if (we->ud == -1)
				{
					if (we->lr == 0)
					{
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x - 1, we->y - 8));
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x + 3, we->y));
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x - 3, we->y));
					}
					else
					{
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x + 1, we->y - 8));
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x + 3, we->y));
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x - 3, we->y));
					}
				}
				else
				{
					if (we->lr == 0)
					{
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x - 1, we->y + 8));
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x + 3, we->y));
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x - 3, we->y));
					}
					else
					{
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x + 1, we->y + 8));
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x - 3, we->y));
						amList.push_back(SetCS_QuoteSuperMissileBlade(we, we->x + 3, we->y));
					}
				}
			}
		}
		else
		{
			if (outOfAmmo_counter == 0)
			{
				SetCS_PeOutOfAmmo(we, we->x, we->y);
				outOfAmmo_counter = outOfAmmo_counter_max;
			}
			we->gameFunc->PlaySound(L"CS_037_gun_click");
		}
		//ס
		mychar->inputLock.SetAtk(true);
	}
	else
		enable = false;
}
