#include "CS_QuoteSpurLaser.h"
#include "CS_PeGunShotSpark.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeHurt.h"
#include "CS_QuoteSpurLaserTail.h"
CS_QuoteSpurLaser::CS_QuoteSpurLaser(std::shared_ptr<Entity> parent, int level)
{
	type = 2;
	attackParent = parent;
	this->level = level;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	auto move = 0x1000 / ts;
	if (ud == -1)
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y - 8;
		vx = 0;
		vy = -move;
		SetCS_PeGunShotSpark(parent, x, y);
	}
	else if (ud == 0)
	{
		y = parent->y + 3;
		if (lr == 0)
		{
			x = parent->x - 6;
			SetCS_PeGunShotSpark(parent, parent->x - 0x1800 / ts, y);
		}
		else
		{
			x = parent->x + 6;
			SetCS_PeGunShotSpark(parent, parent->x + 0x1800 / ts, y);
		}
		vx = lr == 0 ? -move : move;
		vy = 0;
	}
	else
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 8;
		vx = 0;
		vy = move;
		SetCS_PeGunShotSpark(parent, x, y);
	}
	//ʱ
	action_timecounter_max = 30;
	action_timecounter = action_timecounter_max;
	//ö͹
	switch (level)
	{
	default:
	case 0:
		ani.sprite_index = ud == 0 ? L"am_spur1_lr" : L"am_spur1_ud";
		damage = 4;
		damaged_limit = 4;
		break;
	case 1:
		ani.sprite_index = ud == 0 ? L"am_spur2_lr" : L"am_spur2_ud";
		damage = 8;
		damaged_limit = 8;
		break;
	case 2:
		ani.sprite_index = ud == 0 ? L"am_spur3_lr" : L"am_spur3_ud";
		damage = 12;
		damaged_limit = 12;
		break;
	case 3:
		ani.sprite_index = ud == 0 ? L"am_spur4_lr" : L"am_spur4_ud";
		damage = 16;
		damaged_limit = 16;
		action_timecounter_max = 45;
		action_timecounter = action_timecounter_max;
		break;
	case 4:
		ani.sprite_index = ud == 0 ? L"am_spur5_lr" : L"am_spur5_ud";
		damage = 20;
		damaged_limit = 20;
		action_timecounter_max = 60;
		action_timecounter = action_timecounter_max;
		cbRect.enableSoild = false;
		cbRect.enableCbRect = false;
		break;
	}
	damage_reset_counter = 2;
	//ǽײ
	SetCbRect_Collision();
}

void CS_QuoteSpurLaser::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ǽײ
	SetCbRect_Collision();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	//ʵײ
	SetCbRect_Entity();
	damage = damaged_limit - damaged_counter;
	if (damage && damaged_counter > 0)
		damage = 0;
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		auto am = std::make_shared<CS_QuoteSpurLaserTail>(wattackParent, level, ud, lr);
		am->x = x;
		am->y = y;
		gameFunc->SetEntity(shared_from_this(), am);
	}
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
		{
			SetCS_PeGunShotSpark(shared_from_this(), x, y);
			Destroy();
		}
	}
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		gameFunc->PlaySound(L"CS_028_shot_hit");
		SetCS_PeGunShotHit(shared_from_this(), x, y);
		Destroy();
	}
}

void CS_QuoteSpurLaser::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	//˺
	*outDamage = damage;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 3;//ǹ
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_QuoteSpurLaser::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}

void CS_QuoteSpurLaser::Feedback(std::weak_ptr<Entity> target)
{
	if (damaged_counter == damaged_limit)
		Destroy();
}

void CS_QuoteSpurLaser::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void CS_QuoteSpurLaser::SetCbRect_Entity()
{
	switch (level)
	{
	default:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 6;
		break;
	case 3:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 8;
		break;
	case 4:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 16;
		cbRect.enableSoild = false;
		cbRect.enableCbRect = false;
		break;
	}
	cbRect.breakStarBlock = false;
}

void CS_QuoteSpurLaser::SetCbRect_Collision()
{
	switch (level)
	{
	default:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 2;
		break;
	case 4:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 16;
		break;
	}
	cbRect.breakStarBlock = true;
}
