#include "CS_QuoteSpur.h"
#include "CS_Quote.h"
#include "CS_QuoteSpurLaser.h"
const int CS_QuoteSTATENAME_SPUR = GetNextEntityStateID();
CS_QuoteSpur::CS_QuoteSpur()
{
	stateID = CS_QuoteSTATENAME_SPUR;
	cd_counter = 0;
	cd_counter_max = 1;
	iconIndex = 0;
}

const wchar_t* CS_QuoteSpur::GetSaveName()
{
	return L"Spur";
}

const wchar_t* CS_QuoteSpur::GetFuncName()
{
	return L"QuoteSkill_Spur";
}

const wchar_t* CS_QuoteSpur::GetCheckFuncName()
{
	return L"QuoteSkill_Spur_Check";
}

void CS_QuoteSpur::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	bUIShowDisableSkill = !(
		mychar->lastGun != this &&
		!lock
		);
	bool a1 = mychar->lastGun != this &&
		!lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ͻչƷʹþͻ
	openLevel5 = false;
	if (we->gameFunc->PlayerHaveItem)
		if (we->gameFunc->PlayerHaveItem(we->gameFunc->game, L"SpurCharger"))
			openLevel5 = true;
	energy_count_max = openLevel5 ? 400 : 300;
	if (bCharge)
	{
		if (!we->input.GetAtk())
		{
			if (openLevel5)
			{
				if (energy_count >= 400)
				{
					we->gameFunc->PlaySound(L"CS_spur_fire_l6");
					we->gameFunc->SetEntity(we, std::make_shared<CS_QuoteSpurLaser>(we, 4));
				}
				else if (energy_count >= 250)
				{
					we->gameFunc->PlaySound(L"CS_spur_fire_l5");
					we->gameFunc->SetEntity(we, std::make_shared<CS_QuoteSpurLaser>(we, 3));
				}
				else if (energy_count >= 150)
				{
					we->gameFunc->PlaySound(L"CS_064_spur_fire_max");
					we->gameFunc->SetEntity(we, std::make_shared<CS_QuoteSpurLaser>(we, 2));
				}
				else if (energy_count >= 80)
				{
					we->gameFunc->PlaySound(L"CS_063_spur_fire_l3");
					we->gameFunc->SetEntity(we, std::make_shared<CS_QuoteSpurLaser>(we, 1));
				}
				else if (energy_count >= 30)
				{
					we->gameFunc->PlaySound(L"CS_062_spur_fire_l2");
					we->gameFunc->SetEntity(we, std::make_shared<CS_QuoteSpurLaser>(we, 0));
				}
			}
			else
			{
				if (energy_count >= 300)
				{
					we->gameFunc->PlaySound(L"CS_064_spur_fire_max");
					we->gameFunc->SetEntity(we, std::make_shared<CS_QuoteSpurLaser>(we, 2));
				}
				else if (energy_count >= 100)
				{
					we->gameFunc->PlaySound(L"CS_063_spur_fire_l3");
					we->gameFunc->SetEntity(we, std::make_shared<CS_QuoteSpurLaser>(we, 1));
				}
				else if (energy_count >= 40)
				{
					we->gameFunc->PlaySound(L"CS_062_spur_fire_l2");
					we->gameFunc->SetEntity(we, std::make_shared<CS_QuoteSpurLaser>(we, 0));
				}
			}
			energy_count = 0;
			bCharge = false;
		}
	}
	else
	{
		fcounter = 0;
		spur_charge_sound = 0;
	}	
	//޼ȴʱ
	EntitySkillState::SubStep();
	//
	if (openLevel5)
	{
		if (energy_count >= 400)
			fcounter = 1.0f;
		else if (energy_count >= 250)
			fcounter = (energy_count - 250.0f) / 150.0f;
		else if (energy_count >= 150)
			fcounter = (energy_count - 150.0f) / 100.0f;
		else if (energy_count >= 80)
			fcounter = (energy_count - 80.0f) / 70.0f;
		else if (energy_count >= 30)
			fcounter = (energy_count - 30.0f) / 50.0f;
		else
			fcounter = energy_count / 30.0f;
	}
	else
	{
		if (energy_count >= 300)
			fcounter = 1.0f;
		else if (energy_count >= 100)
			fcounter = (energy_count - 100.0f) / 200.0f;
		else if (energy_count >= 40)
			fcounter = (energy_count - 40.0f) / 60.0f;
		else
			fcounter = energy_count / 40.0f;
	}
	if (energy_count > 0)
	{
		if (energyBar.expired())
		{
			auto wenergyBar = std::make_shared<PeReadyBar>(mychar, &fcounter, RGBA(0xff, 0xb5, 0x00, 0xff), 0, -16,
				&CS_QuoteSpur::ReadyBar_Leave,
				&CS_QuoteSpur::ReadyBar_Destroy);
			energyBar = wenergyBar;
			we->gameFunc->SetEntity(we, wenergyBar);
		}
		else
		{
			//ɫ仯
			auto wenergyBar = energyBar.lock();
			wenergyBar->color = (spur_charge_sound / 2 % 2 == 0 ? RGBA(0xff, 0xb5, 0x00, 0xff) : RGBA(0xff, 0xff, 0xff, 0xff));
		}
	}
}

void CS_QuoteSpur::ChangeStateMsg(int stateID)
{
	auto we = e.lock();
	if (!we)
		return;
	auto mychar = std::static_pointer_cast<CS_Quote>(we);

	if (stateID == GetStateID())
	{
		//ʼ
		enable = true;
		//лǹ
		mychar->lastGun = this;
		we->gameFunc->PlaySound(L"CS_004_switchweapon");
	}
	else if (stateID == CS_QuoteSTATENAME_FIRE && amList.size() < 2 &&
		mychar->lastGun == this)
	{
		
		enable = false;
		if (bCharge)
		{
			if (++spur_charge_sound / 2 % 2)
			{
				if (openLevel5)
				{
					if (energy_count <= 30)
						we->gameFunc->PlaySound(L"CS_059_spur_charge0");
					else if (energy_count <= 80)
						we->gameFunc->PlaySound(L"CS_060_spur_charge1");
					else if (energy_count < 150)
						we->gameFunc->PlaySound(L"CS_061_spur_charge2");
					else if (energy_count < 250)
						we->gameFunc->PlaySound(L"CS_spur_charge3");
					else if (energy_count < 400)
						we->gameFunc->PlaySound(L"CS_spur_charge4");
				}
				else
				{
					if (energy_count <= 40)
						we->gameFunc->PlaySound(L"CS_059_spur_charge0");
					else if (energy_count <= 100)
						we->gameFunc->PlaySound(L"CS_060_spur_charge1");
					else if (energy_count < 300)
						we->gameFunc->PlaySound(L"CS_061_spur_charge2");
				}
			}
			if (energy_count < energy_count_max)
			{
				energy_count += 2;
				if (energy_count >= energy_count_max)
				{
					energy_count = energy_count_max;
					if (openLevel5)
						we->gameFunc->PlaySound(L"CS_spur_charged2");
					else
						we->gameFunc->PlaySound(L"CS_065_spur_charged");
				}
			}
		}
		else
		{
			//
			auto am = std::make_shared<CS_QuoteSpurBlade>(we);
			we->gameFunc->SetEntity(we, am);
			amList.push_back(am);
			//
			bCharge = true;
		}
	}
	else
		enable = false;
}

bool CS_QuoteSpur::ReadyBar_Leave(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return true;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	auto& skillSpur = mychar->skillSpur;
	bool bLeave = skillSpur.energy_count == 0;
	if (bLeave)
		skillSpur.energyBar.reset();
	return bLeave;
}

void CS_QuoteSpur::ReadyBar_Destroy(std::weak_ptr<Entity> e)
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	auto& skillSpur = mychar->skillSpur;
	skillSpur.energyBar.reset();
}
