#include "CS_PuuBubble_SoapC.h"
#include "CS_PeSmoke.h"
#include "CS_Enemy_SoapC.h"
CS_PuuBubble_SoapC::CS_PuuBubble_SoapC()
{
	type = 2;
	el.name = CS_PUUBUBBLE_SOAPC_CREATENAME;
	//ײ
	cbRect.enableCbRect = true;
	hp_max = hp = 1;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_puububble_soapC";
	speedDir = true;
}

void CS_PuuBubble_SoapC::Step()
{
	vy += 10 / ts;
	if (cbRect.cbLeft)
		vx = abs(vx);
	if (cbRect.cbRight)
		vx = -abs(vx);
	if (cbRect.cbTop)
		vy = abs(vy);
	if (cbRect.cbBottom)
		vy = -abs(vy);
	lr = vx < 0 ? 0 : 1;
	if (existTime > 0)
	{
		existTime--;
		if (existTime == 0)
		{
			int out;
			Hurt(shared_from_this(), 1, 0, false, 0, 0, 0, &out);
		}
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_PuuBubble_SoapC::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 1;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_PuuBubble_SoapC::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp <= 0)
	{
		gameFunc->PlaySound(L"CS_021_bubble");
		//
		SetCS_PeSmokeWater(shared_from_this(), x, y, 2);
		//SoapA
		auto we = std::make_shared<CS_Enemy_SoapC>();
		we->x = x;
		we->y = y;
		we->lr = lr;
		gameFunc->SetEntity(shared_from_this(), we);
		hp = 0;
		Destroy();
	}
	return true;
}

std::shared_ptr<Entity> CreateCS_PuuBubble_SoapC()
{
	return std::make_shared<CS_PuuBubble_SoapC>();
}

std::weak_ptr<Entity> SetCS_PuuBubble_SoapC(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_PuuBubble_SoapC>();
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
	return am;
}
