#include "CS_PuppyStand.h"
const int CS_PuppySTATENAME_STAND = GetNextEntityStateID();
CS_PuppyStand::CS_PuppyStand()
{
	stateID = CS_PuppySTATENAME_STAND;
	wink_counter = 0;
}

void CS_PuppyStand::State()
{
	auto we = e.lock();
	if (!we)
		return;
	if (sit_counter > 0)
		sit_counter--;
	if (sit_counter == 0)
	{
		//
		we->ani.sprite_index = we->lr == 0 ? L"mc_puppy_sit_l" : L"mc_puppy_sit_r";
	}
	else
	{
		//վ
		we->ani.sprite_index = we->lr == 0 ? L"mc_puppy_stand_l" : L"mc_puppy_stand_r";
	}
	//ڸҡβ
	bool tailAni = false;
	if (we->gameFunc->GetGlobalEntityTable)
	{
		auto & allPlayer = *we->gameFunc->GetGlobalEntityTable(we->gameFunc->game);
		for (auto& p : allPlayer)
		{
			auto wplayer = p.second.lock();
			if (wplayer)
			{
				if (wplayer == we)
					continue;
				if (abs(wplayer->x - we->x) <= 32 && abs(wplayer->y - we->y) <= 32)
				{
					tailAni = true;
					break;
				}
			}
		}
	}
	if (tailAni)
	{
		we->ani.image_counter_speed = 1;
	}
	else
	{
		we->ani.image_counter_speed = 0;
		we->ani.image_index = 0;
	}
	//գ
	if (Random(0, 120) == 10)
	{
		wink_counter = 8;
	}
	if (wink_counter > 0)
	{
		wink_counter--;
		we->ani.hideLayerList.erase(0);
		we->ani.hideLayerList.insert(1);
	}
	else
	{
		we->ani.hideLayerList.erase(1);
		we->ani.hideLayerList.insert(0);
	}
}

void CS_PuppyStand::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
		enable = true;
	else
	{
		if (enable)
		{
			//뿪״̬ʱ
			auto we = e.lock();
			if (we)
			{
				auto mychar = std::static_pointer_cast<MyCharEntity>(we);
				mychar->ani.hideLayerList.erase(1);
				mychar->ani.hideLayerList.insert(0);
			}
			sit_counter = sit_counter_max;
		}
		enable = false;
	}
}
