#include "CS_PuppyAi.h"
#include "CS_Puppy.h"
#include "CS_Boss_Puu.h"
CS_PuppyAi::CS_PuppyAi()
{
	el.name = CS_PUPPYAI_CREATENAME;
}

void CS_PuppyAi::Init(std::weak_ptr<Entity> self)
{
	auto watkZone = std::make_shared<CS_Ai_AtkZone>();
	atkZone = watkZone;
	//ýӴοΧ
	watkZone->cbRect.left = 5 * 16;
	watkZone->cbRect.right = 5 * 16;
	watkZone->cbRect.top = 2 * 16;
	watkZone->cbRect.bottom = 2 * 16;
	gameFunc->SetEntity(shared_from_this(), watkZone);
	CS_MyCharAi::Init(self);
}

void CS_PuppyAi::Step()
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
	{
		Destroy();
		return;
	}
	if (atk_interval_counter > 0)
		atk_interval_counter--;

	auto mychar = std::static_pointer_cast<CS_Puppy>(wattackParent);
	if (!mychar)
	{
		InitControlTarget();
		return;
	}
	CS_MyCharAi::Step();
	//СʾAIͼ
	auto wicon = icon.lock();
	if (wicon)
		wicon->ani.sprite_index.clear();
	auto watkZone = atkZone.lock();
	if (watkZone)
	{
		//󶨹
		watkZone->x = mychar->x;
		watkZone->y = mychar->y;
		watkZone->last_x = mychar->last_x;
		watkZone->last_y = mychar->last_y;
		//Ŀͷ
		x = wattackParent->x;
		y = wattackParent->y - 16;
		last_x = wattackParent->last_x;
		last_y = wattackParent->last_y - 16;
	}
}

void CS_PuppyAi::Destroy()
{
	auto watkZone = atkZone.lock();
	if (watkZone)
	{
		watkZone->Destroy();
		atkZone.reset();
	}
	CS_MyCharAi::Destroy();
}

bool CS_PuppyAi::AttackAround()
{
	if (!FilterEnemy())
		return false;
	return StaticAttack(enemyList.front());
}

bool CS_PuppyAi::FilterEnemy()
{
	auto watkZone = atkZone.lock();
	if (!watkZone)
		return false;

	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return false;
	auto mychar = std::static_pointer_cast<CS_Puppy>(wattackParent);
	//鿴ǷԼΧ
	enemyList.clear();
	for (auto& e : watkZone->touchList)
	{
		auto we = e.lock();
		if (we)
		{
			//
			if (we->type != 2)
				continue;
			//
			if (we->isTrap)
				continue;
			if (we->hp == 0)
				continue;
			//ҷ
			auto we_attackParent = we->attackParent.lock();
			if (we_attackParent && we_attackParent->type == 1)
				continue;
			auto cell = gameFunc->GetPath(mychar, we->x / 16, we->y / 16, mychar->x / 16, mychar->y / 16);
			//ֱ߲
			if (gameFunc->LineTest(mychar, mychar->x / 16, mychar->y / 16, we->x / 16, we->y / 16))
				continue;
			//Ѱ·Զ
			if (cell->dis > 10)
				continue;
			enemyList.push_back(we);
		}
	}
	return !enemyList.empty();
}

bool CS_PuppyAi::StaticAttack(std::weak_ptr<Entity> e)
{
	auto wattackParent = attackParent.lock();
	if (!wattackParent)
		return false;
	auto mychar = std::static_pointer_cast<CS_Puppy>(wattackParent);
	auto we = e.lock();
	if (!we)
		return false;

	if (we->y >= mychar->y)
	{
		//ת
		if (we->x > mychar->x && mychar->lr == 0)
			mychar->input.SetRight(true);
		else if (we->x < mychar->x && mychar->lr == 1)
			mychar->input.SetLeft(true);
		//ͣ¶
		if (atk_interval_counter == 0)
		{
			atk_interval_counter = atk_interval_counter_max;
			mychar->input.SetAtk(true);
		}
		return true;
	}
	//ֱӹ
	if (atk_interval_counter == 0)
	{
		atk_interval_counter = atk_interval_counter_max;
		mychar->input.SetAtk(true);
	}
	return false;
}

std::shared_ptr<Entity> CreateCS_PuppyAi()
{
	return std::make_shared<CS_PuppyAi>();
}
