#include "CS_PeWaterParticles.h"

CS_PeWaterParticles::CS_PeWaterParticles()
{
	type = 3;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"pe_water_particles";
	drawBeforeOtherEntity = true;
}

void CS_PeWaterParticles::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		ani_no = Random(0, 2);

		switch (direct)
		{
		case 0:
			vx = -1;
			break;

		case 1:
			vy = -1;
			break;

		case 2:
			vx = 1;
			break;

		case 3:
			vy = 1;
			break;
		}

		vx *= Random(4, 8) / 2;
		vy *= Random(4, 8) / 2;
		break;
	}

	if (++ani_wait > 6)
	{
		ani_wait = 0;
		++ani_no;
	}

	if (ani_no > 4)
		Destroy();
	//ִ˶
	Entity::Step();
}

void SetCS_PeWaterParticles(std::shared_ptr<Entity> parent, float x, float y, int dir)
{
	auto pe = std::make_shared<CS_PeWaterParticles>();
	pe->x = x;
	pe->y = y;
	pe->direct = dir;
	parent->gameFunc->SetEntity(parent, pe);
}
