#include "CS_PeSmoke.h"
#include "CS_PeFlash.h"
CS_PeSmoke::CS_PeSmoke()
{
	type = 3;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"pe_smoke_white";
	ani.image_index = Random(0, 4);
	ani_wait = Random(0, 3);
	float angle = (float)Random(0, 360);
	vx = cosf(angle * deg2rad) * Random(0x200, 0x5FF) / 0x200;
	vy = sinf(angle * deg2rad) * Random(0x200, 0x5FF) / 0x200;
}

void CS_PeSmoke::Step()
{
	auto& ani_no = ani.image_index;
	// Slight drag
	vx = 20 * vx / 21;
	vy = 20 * vy / 21;

	// Animate
	if (++ani_wait > 4)
	{
		ani_wait = 0;
		ani_no++;
	}

	// Set framerect
	if (ani_no > 7)
	{
		// Destroy if over
		Destroy();
	}
	switch (style)
	{
	default:
	case 0:
		ani.sprite_index = L"pe_smoke_white";
		break;
	case 1:
		ani.sprite_index = L"pe_smoke_gold";
		break;
	case 2:
		ani.sprite_index = L"pe_smoke_water";
		break;
	}
	//ִ˶
	Entity::Step();
}

std::shared_ptr<Entity> CreateCS_PeSmoke()
{
	return std::make_shared<CS_PeSmoke>();
}

void SetCS_PeSmoke(std::shared_ptr<Entity> parent, float x, float y, int num)
{
	for (size_t i = 0; i < num; i++)
	{
		float offset_x = (float)Random((int)-parent->cbRect.left, (int)parent->cbRect.right);
		float offset_y = (float)Random((int)-parent->cbRect.top, (int)parent->cbRect.bottom);
		auto e = std::make_shared<CS_PeSmoke>();
		e->x = x + offset_x;
		e->y = y + offset_y;
		parent->gameFunc->SetEntity(parent, e);
	}
	//Ч
	SetCS_PeFlash(parent, x, y);
}

void SetCS_PeSmoke2(std::shared_ptr<Entity> parent, float x, float y)
{
	float offset_x = (float)Random((int)-parent->cbRect.left, (int)parent->cbRect.right);
	float offset_y = (float)Random((int)-parent->cbRect.top, (int)parent->cbRect.bottom);
	auto e = std::make_shared<CS_PeSmoke>();
	e->x = x + offset_x;
	e->y = y + offset_y;
	parent->gameFunc->SetEntity(parent, e);
	SetCS_PeFlash(parent, e->x, e->y);
}

void SetCS_PeSmokeWater(std::shared_ptr<Entity> parent, float x, float y, int num)
{
	for (size_t i = 0; i < num; i++)
	{
		float offset_x = (float)Random((int)-parent->cbRect.left, (int)parent->cbRect.right);
		float offset_y = (float)Random((int)-parent->cbRect.top, (int)parent->cbRect.bottom);
		auto e = std::make_shared<CS_PeSmoke>();
		e->x = x + offset_x;
		e->y = y + offset_y;
		e->style = 2;
		parent->gameFunc->SetEntity(parent, e);
	}
	//Ч
	SetCS_PeFlash(parent, x, y);
}
