#include "CS_PeLittleStar.h"

CS_PeLittleStar::CS_PeLittleStar()
{
	type = 3;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"pe_little_star";
	vx = Random(-0x600, 0x600) / ts;
	vy = Random(-0x200, 0x200) / ts;
	topDraw = true;
	action_timecounter = action_timecounter_max = 20;
	sleep_counter = 20;
}

void CS_PeLittleStar::Step()
{
	vx *= 0.8f;
	vy *= 0.8f;
	//ִ˶
	Entity::Step();
	if (sleep_counter > 0)
		sleep_counter--;
	else if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
			Destroy();
	}
	color = RGBA(0xff, 0xff, 0xff, BYTE(action_timecounter * 0xff / action_timecounter_max));
}

void SetCS_PeLittleStar(std::shared_ptr<Entity> parent, float x, float y)
{
	auto pe = std::make_shared<CS_PeLittleStar>();
	pe->x = x;
	pe->y = y;
	parent->gameFunc->SetEntity(parent, pe);
}
