#include "CS_MiseryStandAni.h"

CS_MiseryStandAni::CS_MiseryStandAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	auto& ani_no = ani.image_index;
	ani_no = 2;
}

void CS_MiseryStandAni::Step()
{
	if (act_no < 200)
	{
		auto& ani_no = ani.image_index;
		switch (act_no)
		{
		case 0:
			act_no = 1;
			ani_no = 2;
			[[fallthrough]];
		case 1:
			if (Random(0, 120) == 10)
			{
				act_no = 2;
				act_wait = 0;
				ani_no = 3;
			}
			break;
		case 2:
			if (++act_wait > 8)
			{
				act_no = 1;
				ani_no = 2;
			}
			break;
		case 20:
			act_no = 21;
			ani_no = 0;
			vy = 0;
			cbRect.enableSoild = false;
			[[fallthrough]];
		case 21:
			vy -= 0x20 / ts;
			if (y < -0x1000 / ts)
				Destroy();
			break;
		case 25:
			act_no = 26;
			act_wait = 0;
			ani_no = 5;
			ani_wait = 0;
			[[fallthrough]];
		case 26:
			if (++ani_no > 7)
				ani_no = 5;
			if (++act_wait == 30)
			{
				gameFunc->PlaySound(L"CS_101_lightning_strike");
				gameFunc->SetScreenFlash(gameFunc->gameFlash, 20);
				act_no = 27;
				ani_no = 7;
			}
			break;
		case 27:
			if (++act_wait == 50)
			{
				act_no = 0;
				ani_no = 0;
			}
			break;
		case 30:
			act_no = 31;
			ani_no = 3;
			ani_wait = 0;
			[[fallthrough]];
		case 31:
			if (++ani_wait > 10)
			{
				act_no = 32;
				ani_no = 4;
				ani_wait = 0;
			}
			break;
		case 32:
			if (++ani_wait > 100)
			{
				act_no = 1;
				ani_no = 2;
			}
			break;
		}
		//ִ˶
		Entity::Step();
		if (act_no == 11)
		{
			if (ani_wait)
			{
				--ani_wait;
				ani_no = 1;
			}
			else
			{
				if (Random(0, 100) == 1)
					ani_wait = 30;

				ani_no = 0;
			}
		}

		if (act_no == 14)
		{
			if (ani_wait)
			{
				--ani_wait;
				ani_no = 3;
			}
			else
			{
				if (Random(0, 100) == 1)
					ani_wait = 30;

				ani_no = 2;
			}
		}
		ani.sprite_index = lr == 0 ? L"mc_misery_stand_l" : L"mc_misery_stand_r";
	}
	else
	{
		switch (act_no)
		{
		case 200:
			ani.sprite_index = L"mc_misery_bill";
			break;
		}
	}
}

void CS_MiseryStandAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	act_no = stateID;
	if (stateID < 200)
		ani.sprite_index = lr == 0 ? L"mc_misery_stand_l" : L"mc_misery_stand_r";
}

void CS_MiseryStandAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"float_leave")
		SetState(20, lr);
	else if (stateName == L"magic_powerful")
		SetState(25, lr);
	else if (stateName == L"magic")
		SetState(30, lr);
	else if (stateName == L"bill")
		SetState(200, lr);
}

std::shared_ptr<Entity> CreateCS_MiseryStandAni()
{
	return std::make_shared<CS_MiseryStandAni>();
}
