#include "CS_LavaDrop.h"
#include "CS_PeLava.h"
#include "CS_PeSmoke.h"
CS_LavaDrop::CS_LavaDrop()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_lavadrop";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.left = 2;
	cbRect.right = 2;
	cbRect.top = 7;
	cbRect.bottom = 4;
	noDir = true;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	isTrap = true;
	ignoreCaught = true;
	drawBeforeOtherEntity = true;
}

void CS_LavaDrop::Step()
{
	vy += 0x40 / ts;
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	if (cbRect.inWater)
	{
		if (cbRect.inLava)
		{
			Destroy();
			//ҽ
			for (int i = 0; i < 3; i++)
				SetCS_PeLava(shared_from_this(), x, y + 4);
			//Ļ򲥷
			if (gameFunc->InScreen(gameFunc->entityRes, x, y))
				gameFunc->PlaySound(L"CS_021_bubble");
		}
		else
		{
			//
			Destroy();
			auto pe = CreateCS_PeSmoke();
			pe->x = x;
			pe->y = y;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
	}
	else if (cbRect.cbBottom)
	{
		//
		Destroy();
		auto pe = CreateCS_PeSmoke();
		pe->x = x;
		pe->y = y;
		gameFunc->SetEntity(shared_from_this(), pe);
	}
}

void CS_LavaDrop::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void CS_LavaDrop::Feedback(std::weak_ptr<Entity> target)
{
	//
	Destroy();
	auto pe = CreateCS_PeSmoke();
	pe->x = x;
	pe->y = y;
	gameFunc->SetEntity(shared_from_this(), pe);
}

std::shared_ptr<Entity> CreateCS_LavaDrop()
{
	return std::make_shared<CS_LavaDrop>();
}
