#include "CS_KingStand.h"
const int CS_KingSTATENAME_STAND = GetNextEntityStateID();
CS_KingStand::CS_KingStand()
{
	stateID = CS_KingSTATENAME_STAND;
	wink_counter = 0;
}

void CS_KingStand::State()
{
	auto we = e.lock();
	if (!we)
		return;

	const wchar_t* stand = L"";
	if (we->ud == -1)
		stand = we->lr == 0 ? L"mc_king_stand_lu" : L"mc_king_stand_ru";
	else
		stand = we->lr == 0 ? L"mc_king_stand_l" : L"mc_king_stand_r";
	we->ani.sprite_index = stand;
	//գ
	if (Random(0, 120) == 10)
	{
		wink_counter = 8;
	}
	if (wink_counter > 0)
	{
		wink_counter--;
		we->ani.image_index = 1;
	}
	else
	{
		we->ani.image_index = 0;
	}
}

void CS_KingStand::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
		enable = true;
	else
		enable = false;
}
