#include "CS_KingAni.h"
#include "CS_KingSword.h"
CS_KingAni::CS_KingAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_KingAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_KingAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	switch (stateID)
	{
	default:
	case 0://գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		stateGravity.State();
		stateSplash.State();
		break;
	case 4://ڴ
		vx = 0;
		vy = 0;
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	//
	auto wsword = sword.lock();
	if (wsword)
	{
		wsword->x = x + (lr == 0 ? -8 : 8);
		wsword->y = y + 2;
		wsword->last_x = last_x + (lr == 0 ? -8 : 8);
		wsword->last_y = last_y + 2;
		wsword->lr = lr;
	}
}

void CS_KingAni::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	//ö
	switch (stateID)
	{
	case 0://վ
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_king_stand_l" : L"mc_king_stand_r";
		if (ud == -1)
			ani.sprite_index.append(L"u");
		break;
	case 1://·
		{
			animation_delay = true;
			if (lr == 0)
				vx = -animation_moveSpeed;
			else
				vx = animation_moveSpeed;
			const wchar_t* move = L"";
			if (ud == -1)
				move = lr == 0 ? L"mc_king_move_lu" : L"mc_king_move_ru";
			else
				move = lr == 0 ? L"mc_king_move_l" : L"mc_king_move_r";
			ani.sprite_index = move;
		}
		break;
	case 2://
		vx = 0;
		ani.sprite_index = lr == 0 ? L"mc_king_back_l" : L"mc_king_back_r";
		break;
	case 4://ڴ
		vx = 0;
		y -= 6;
		x -= 11;
		ani.sprite_index = lr == 0 ? L"mc_king_sit_l" : L"mc_king_sit_r";
		break;
	}
}

void CS_KingAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"sit_on_bed")
		SetState(4, lr);
	else if (stateName == L"sit_atk")
		ani.sprite_index = lr == 0 ? L"mc_king_sit2_l" : L"mc_king_sit2_r";
	else if (stateName == L"topdraw")
	{
		topDraw = lr != 0;
		auto wsword = sword.lock();
		if (wsword)
			wsword->topDraw = topDraw;
	}	
	else if (stateName == L"show_sword")
	{
		auto wsword = std::make_shared<CS_KingSword>();
		sword = wsword;
		wsword->x = x + (lr == 0 ? -8 : 8);
		wsword->y = y + 2;
		gameFunc->SetEntity(shared_from_this(), wsword);
	}
}

void CS_KingAni::Destroy()
{
	auto wsword = sword.lock();
	if (wsword)
		wsword->Destroy();
	Entity::Destroy();
}

std::shared_ptr<Entity> CreateCS_KingAni()
{
	return std::make_shared<CS_KingAni>();
}
