#include "CS_Enemy_Skeleton.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_AmSkeletonProjectile.h"

CS_Enemy_Skeleton::CS_Enemy_Skeleton()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 13;
	cbRect.bottom = 8;
	hp_max = hp = 40;
	dropExp = 20;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_Skeleton::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Skeleton::Step()
{
	auto& ani_no = ani.image_index;
	stateSplash.Step();
	std::shared_ptr<Entity> wplayer;
	if (gameFunc->GetPlayerDistance)
		wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
	if (wplayer)
	{
		if (wplayer->x < x - 0x2C000 / ts || wplayer->x > x + 0x2C000 / ts ||
			wplayer->y < y - 0x14000 / ts || wplayer->y > y + 0x8000 / ts)
			act_no = 0;
	}
	switch (act_no)
	{
	case 0:
		act_no = 1;
		vx = 0;
		[[fallthrough]];
	case 1:
		if (wplayer)
		{
			if (wplayer->x > x - 0x28000 / ts && wplayer->x < x + 0x28000 / ts &&
				wplayer->y > y - 0x14000 / ts && wplayer->y < y + 0x8000 / ts)
				act_no = 10;
		}
		if (cbRect.cbBottom)
			ani_no = 0;
		break;
	case 10:
		vx = 0;
		act_no = 11;
		act_wait = 0;
		ani_no = 0;
		[[fallthrough]];
	case 11:
		if (++act_wait >= 5 && cbRect.cbBottom)
		{
			act_no = 20;
			ani_no = 1;
			count1 = 0;
			vy = -(float)Random(1, 3);
			if (wplayer)
			{
				if (shock_counter > 0)
				{
					if (x < wplayer->x)
						vx -= 0x100 / ts;
					else
						vx += 0x100 / ts;
				}
				else
				{
					if (x < wplayer->x)
						vx += 0x100 / ts;
					else
						vx -= 0x100 / ts;
				}
			}
		}
		break;
	case 20:
		if (vy > 0 && count1 == 0)
		{
			++count1;
			if (wplayer)
			{
				if (!gameFunc->LineTest(shared_from_this(), x / 16, y / 16, wplayer->x / 16, wplayer->y / 16))
				{
					XMVECTOR vec = XMVector2Normalize(XMVectorSet(wplayer->x - x, wplayer->y - y, 0, 0));
					SetCS_AmSkeletonProjectile(shared_from_this(), x, y, 2 * XMVectorGetX(vec), 2 * XMVectorGetY(vec));
					gameFunc->PlaySound(L"CS_039_em_fire");
				}
			}
		}
		if (cbRect.cbBottom)
		{
			act_no = 10;
			ani_no = 0;
		}
		break;
	}
	if (wplayer)
	{
		if (act_no >= 10)
		{
			if (x > wplayer->x)
				lr = 0;
			else
				lr = 1;
		}
	}
	vy += 0x33 / ts;
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;

	if (vx > 0x5FF/ts)
		vx = 0x5FF/ts;
	if (vx < -0x5FF / ts)
		vx = -0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	ani.sprite_index = lr == 0 ? L"ls_skeleton_l" : L"ls_skeleton_r";
}

void CS_Enemy_Skeleton::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_skeleton_l" : L"ls_skeleton_r";
}

void CS_Enemy_Skeleton::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 6;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Skeleton::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_Skeleton()
{
	return std::make_shared<CS_Enemy_Skeleton>();
}
