#include "CS_Enemy_Shrimp.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_PeBubbleBeamHit.h"

CS_Enemy_Shrimp::CS_Enemy_Shrimp()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 6;
	cbRect.bottom = 8;
	hp_max = hp = 9;
	dropExp = 5;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
}

void CS_Enemy_Shrimp::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_Shrimp::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	if (cbRect.inWater)
		stateGravity.SetGravityScale(0.5f);
	else
		stateGravity.SetGravityScale(1);
	stateGravity.Step();
	stateSplash.Step();
	if (cbRect.cbBottom)
		vx /= 1.05f;
	else
		vx /= 1.01f;
	if (abs(vx) < 0.001f)
		vx = 0;
	if (!bSleep && wake_counter == 0)
	{
		if (dash_counter > 0)
		{
			if (dash_interval_counter > 0)
				dash_interval_counter--;
			else
			{
				dash_counter--;
				dash_interval_counter = dash_interval_counter_max;
				Dash();
			}
		}
		else if(cbRect.cbBottom)
		{
			//ص˯
			if (sleep_counter > 0)
			{
				sleep_counter--;
			}
			else
			{
				bSleep = true;
			}
		}
	}
	if (wake_counter > 0)
		wake_counter--;
	//ҿ̫
	if (gameFunc->GetPlayerDistanceWithLineTest)
	{
		auto wplayer = gameFunc->GetPlayerDistanceWithLineTest(gameFunc->game, x, y).lock();
		if (wplayer)
		{
			if (abs(x - wplayer->x) <= 32 && abs(y - wplayer->y) <= 32)
				SetAction();
		}
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	float lastVx = vx;
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
	//ǽ
	if (cbRect.cbLeft)
	{
		lr = 0;
		vx = abs(lastVx);
	}
	else if (cbRect.cbRight)
	{
		lr = 1;
		vx = -abs(lastVx);
	}
	//
	if (flash_counter > 0)
	{
		if (flash_counter / 2 % 2 == 0)
			ani.png = L"";
		else
			ani.png = L"CS_CaveStoryMod";
		flash_counter--;
	}
	else
		ani.png = L"CS_CaveStoryMod";
	if (bSleep)
	{
		ani.sprite_index = lr == 0 ? L"ls_shrimp_sleep_l" : L"ls_shrimp_sleep_r";
	}
	else
	{
		if (wake_counter > 0)
		{
			ani.sprite_index = lr == 0 ? L"ls_shrimp_wake_l" : L"ls_shrimp_wake_r";
		}
		else
		{
			ani.sprite_index = lr == 0 ? L"ls_shrimp_swim_l" : L"ls_shrimp_swim_r";
		}
	}
}

void CS_Enemy_Shrimp::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_shrimp_sleep_l" : L"ls_shrimp_sleep_r";
}

void CS_Enemy_Shrimp::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_Shrimp::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	flash_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_sea_enemy_hurt1");
		SetAction();
	}
	else
	{
		gameFunc->PlaySound(L"CS_sea_destroy1");
		//
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_Shrimp::Dash()
{
	gameFunc->PlaySound(L"CS_sea_enemy_shrimp");
	vx = lr == 0 ? 0x800 / ts : -0x800 / ts;
	vy = -0x400 / ts;
	SetCS_PeBubbleBeamHit(shared_from_this(), x, y);
}

void CS_Enemy_Shrimp::SetAction()
{
	if (bSleep)
	{
		dash_counter = dash_counter_max;
		dash_interval_counter = 0;
		wake_counter = wake_counter_max;
		sleep_counter = sleep_counter_max;
		bSleep = false;
	}
	else if (cbRect.cbBottom)
	{
		dash_counter = dash_counter_max;
		dash_interval_counter = 0;
		sleep_counter = sleep_counter_max;
	}
}

std::shared_ptr<Entity> CreateCS_Enemy_Shrimp()
{
	return std::make_shared<CS_Enemy_Shrimp>();
}
