#include "CS_Enemy_Chinfish.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_PeWaterDrop.h"

CS_Enemy_Chinfish::CS_Enemy_Chinfish()
{
	//Ѷ
	caughtDifficulty = 0.5f;
}

void CS_Enemy_Chinfish::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_chinfish_swim_l" : L"ls_chinfish_swim_r";
}

void CS_Enemy_Chinfish::FleeEnd()
{
	initPos = true;
}

void CS_Enemy_Chinfish::HurtAnimate()
{
	ani.sprite_index = lr == 0 ? L"ls_chinfish_hurt_l" : L"ls_chinfish_hurt_r";
}

void CS_Enemy_Chinfish::AnimateSpeedStep()
{
	ani.image_counter_speed = 1;
}

void CS_Enemy_Chinfish::SwimStep()
{
	if (initPos)
	{
		initPos = false;
		srcX = x;
		srcY = y;
		vy = 0x80 / ts;
	}
	vx = 0;
	if (srcY < y)
		vy -= 8 / ts;
	if (srcY > y)
		vy += 8 / ts;
	if (vy > 0x100)
		vy = 0x100;
	if (vy < -0x100)
		vy = -0x100;
	ani.sprite_index = lr == 0 ? L"ls_chinfish_swim_l" : L"ls_chinfish_swim_r";
}

std::shared_ptr<Entity> CreateCS_Enemy_Chinfish()
{
	return std::make_shared<CS_Enemy_Chinfish>();
}
