#include "CS_Enemy_Arowana.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_PeWaterDrop.h"
CS_Enemy_Arowana::CS_Enemy_Arowana()
{
	//Ѷ
	caughtDifficulty = 0.8f;
	swimModeChangeCounter = 1;
	hp_max = hp = 50;
	dropExp = 20;
	cbRect.left = 24;
	cbRect.right = 24;
	cbRect.bottom = cbRect.top = 8;
}

void CS_Enemy_Arowana::Init(std::weak_ptr<Entity> self)
{
	auto wpeDizzy = std::make_shared<CS_PeDizzy>(shared_from_this());
	peDizzy = wpeDizzy;
	gameFunc->SetEntity(shared_from_this(), wpeDizzy);
	CS_Fish::Init(self);
}

void CS_Enemy_Arowana::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_arowana_swim_l" : L"ls_arowana_swim_r";
	AnimateStep();
}

void CS_Enemy_Arowana::Step()
{
	if (hp < 20 && !cbRect.inWater && cbRect.cbBottom)
	{
		bShowDizzy = true;
	}
	AnimateStep();
	CS_Fish::Step();
}

void CS_Enemy_Arowana::HurtAnimate()
{
	if (bShowDizzy)
		face = 2;
	else
		face = 1;
	ani.sprite_index = lr == 0 ? L"ls_arowana_swim_l" : L"ls_arowana_swim_r";
}

void CS_Enemy_Arowana::AnimateSpeedStep()
{
	float sp = max(abs(vx), abs(vy));
	ani.image_counter_speed = sp * 2;
	if (ani.image_counter_speed < 0.1f)
		ani.image_index = 0;
}

void CS_Enemy_Arowana::SwimStep()
{
	//Ӿ
	if (swimModeChangeCounter > 0)
	{
		swimModeChangeCounter--;
		if (swimModeChangeCounter == 0)
		{
			//ıӾ̬
			float speedX = Random(-0x600, 0x600) / ts;
			float speedY = Random(-0x300, 0x300) / ts;
			vx += speedX;
			vy += speedY;
			lr = vx < 0 ? 0 : 1;
			swimModeChangeCounter = Random(10, 120);
		}
	}
	ResistStep();
	if (lr == 0 && cbRect.cbLeft)
	{
		lr = 1;
		vx = Random(0, 0x600) / ts;
	}
	else if (lr == 1 && cbRect.cbRight)
	{
		lr = 0;
		vx = Random(-0x600, 0) / ts;
	}
	ani.sprite_index = lr == 0 ? L"ls_arowana_swim_l" : L"ls_arowana_swim_r";
	face = 0;
}

void CS_Enemy_Arowana::Destroy()
{
	auto wpeDizzy = peDizzy.lock();
	if (wpeDizzy)
		wpeDizzy->Destroy();
	CS_Fish::Destroy();
}

void CS_Enemy_Arowana::EndCaught(std::weak_ptr<Entity> e)
{
	CS_Fish::EndCaught(e);
}

void CS_Enemy_Arowana::AnimateStep()
{
	auto wpeDizzy = peDizzy.lock();
	if (wpeDizzy)
		wpeDizzy->hide = !bShowDizzy;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	ani.hideLayerList.insert(4);
	ani.hideLayerList.insert(5);
	ani.hideLayerList.insert(6);

	ani.hideLayerList.insert(7);
	ani.hideLayerList.insert(8);
	ani.hideLayerList.insert(9);
	if (bShowSilkRibbon)
		ani.hideLayerList.erase(7);
	else
		ani.hideLayerList.insert(7);
	switch (face)
	{
	case 0://
		ani.hideLayerList.erase(4);
		ani.hideLayerList.erase(8);
		break;
	case 1://
		ani.hideLayerList.erase(3);
		ani.hideLayerList.erase(9);
		break;
	case 2://ѣ
		ani.hideLayerList.erase(2);
		ani.hideLayerList.erase(9);
		break;
	case 3://
		ani.hideLayerList.erase(0);
		ani.hideLayerList.erase(1);
		ani.hideLayerList.erase(9);
		break;
	case 4://˯
		ani.hideLayerList.erase(5);
		ani.hideLayerList.erase(8);
		break;
	case 5://
		ani.hideLayerList.erase(6);
		ani.hideLayerList.erase(8);
		break;
	}
}

std::shared_ptr<Entity> CreateCS_Enemy_Arowana()
{
	return std::make_shared<CS_Enemy_Arowana>();
}
