#include "CS_CurlyResist.h"
#include "CS_Curly.h"
#include "EntityStateResist.h"
const int& CS_CurlySTATENAME_RESIST = ES_STATENAME_RESIST;
CS_CurlyResist::CS_CurlyResist()
{
	SetPhysice(false);
	resist = resist_default;
	enable = true;
	stateID = CS_CurlySTATENAME_RESIST;
}

void CS_CurlyResist::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Curly>(we);
	resist = resist_default;
	if (mychar->fishState)
	{
		//
		if (we->vx < 0)
			if (we->vx > -resist)
				we->vx = 0;
			else
				we->vx += resist;
		if (we->vx > 0)
			if (we->vx < resist)
				we->vx = 0;
			else
				we->vx -= resist;
	}
	else
	{
		//
		if (we->cbRect.cbBottom && !PxaIsIce(we->cbRect.pxaBottom) && !(we->cbRect.cbLeft || we->cbRect.cbRight))
		{
			if (we->vx < 0)
				if (we->vx > -resist)
					we->vx = 0;
				else
					we->vx += resist;
			if (we->vx > 0)
				if (we->vx < resist)
					we->vx = 0;
				else
					we->vx -= resist;
		}
	}
}

void CS_CurlyResist::SetPhysice(bool bInWater)
{
	if (bInWater)
		resist_default = inwater_resist_default;
	else
		resist_default = ground_resist_default;
}
