#pragma once
#include "Entity.h"
#include "EntityStateGravity.h"
#include "EntityStateSplash.h"
#include "PeLightTail.h"
#define CS_BOSS_TAP_CREATENAME L"CS_boss_tap"

enum TapAttackMode
{
    TapAttackMode_Paper,
    TapAttackMode_Scissors,
    TapAttackMode_Rock,
};

class CS_Boss_TapDmgRect;
//Boss
class CS_Boss_Tap :
    public ActionEntity
{
public:
    CS_Boss_Tap();
    void Init(std::weak_ptr<Entity> self) override;
    void Step() override;
    void SetState(int stateID, int lr) override;
    void SetState(std::wstring stateName, int lr) override;
    bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
    void Destroy() override;
    void SetAttackRect(float left, float right, float top, float bottom);
    EntityStateGravity stateGravity;
    EntityStateSplash stateSplash;
    //
    int stateID = 0;
    bool bAction = false;
    float walkSound = 0;
    float srcVx = 0;
    int drop_counter = 0;
    bool bHurtBlock = true;//˺ֻͨCS_Boss_TapDmgRect::Hurtõ
    std::weak_ptr<PeLightTail> lightTail;
    std::weak_ptr<Entity> target;
    std::weak_ptr<CS_Boss_TapDmgRect> dmgRect;
    std::list<TapAttackMode> attackModeList;//ģʽ
    std::vector<float> scissorsFallLocation;
    int slash_count = 0;
    bool bSetSlashDir = false;
    int windShield_count = 0;
    int hammerblow_count = 0;
    std::weak_ptr<Entity> chainBat;
    std::weak_ptr<Entity> press;
    std::vector<int> argbuff;
    float leftSide = 0, rightSide = 0;
    bool initArg = true;
    bool bNormalMode = false;
};

std::shared_ptr<Entity> CreateCS_Boss_Tap();