#include "CS_Boss_MonsterXEye.h"
#include "CS_Boss_MonsterX.h"

CS_Boss_MonsterXEye::CS_Boss_MonsterXEye(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
}

void CS_Boss_MonsterXEye::Init(std::weak_ptr<Entity> self)
{
	srcX = x;
	srcY = y;
	ActionEntity::Init(self);
}

void CS_Boss_MonsterXEye::Step()
{
	switch (stateID)
	{
	case 0:
		break;
	case 1://׼պ۾
		ani.image_index = 1;
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			bHurtBlock = true;
			ani.image_index = 0;
			stateID = 0;
		}
		break;
	case 2://׼
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			action_timecounter = 32;
			ani.image_index = 0;
			stateID = 3;
		}
		break;
	case 3:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			action_timecounter = 32;
			ani.image_index = 6;
			stateID = 4;
		}
		break;
	case 4:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			action_timecounter = 60;
			ani.image_index = 7;
			stateID = 5;
		}
		break;
	case 5:
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			ani.sprite_index = lr == 0 ? L"ls_monsterx_eyeflash_l" : L"ls_monsterx_eyeflash_r";
			stateID = 0;
		}
		break;
	case 6://۾
		ani.image_index = 1;
		if (action_timecounter > 0)
			action_timecounter--;
		if (action_timecounter == 0)
		{
			bHurtBlock = false;
			ani.image_index = 2;
			stateID = 0;
		}
		break;
	}
	ActionEntity::Step();
}

void CS_Boss_MonsterXEye::SetState(int stateID, int lr)
{
	this->lr = lr;
	//þο
	cbRect.top = 24;
	cbRect.bottom = 8;
	if (lr == 0)
	{
		cbRect.left = 40;
		cbRect.right = 8;
	}
	else
	{
		cbRect.right = 40;
		cbRect.left = 8;
	}
	ani.image_index = stateID;
	ani.sprite_index = lr == 0 ? L"ls_monsterx_eye_l" : L"ls_monsterx_eye_r";
}

void CS_Boss_MonsterXEye::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"show")
	{
		ani.png = L"CS_CaveStoryMod";
		bFight = true;
	}
	else if (stateName == L"close_eyes")
	{
		stateID = 1;
		action_timecounter = 32;
		ani.sprite_index = lr == 0 ? L"ls_monsterx_eye_l" : L"ls_monsterx_eye_r";
	}
	else if (stateName == L"open_eyes")
	{
		stateID = 6;
		action_timecounter = 32;
		ani.sprite_index = lr == 0 ? L"ls_monsterx_eye_l" : L"ls_monsterx_eye_r";
	}
	else if (stateName == L"laser_eyes")
	{
		stateID = 2;
		action_timecounter = 32;
	}
}

bool CS_Boss_MonsterXEye::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (!bFight)
		return false;
	if (bHurtBlock)
		return false;
	auto wattackParent = attackParent.lock();
	if (wattackParent)
		return wattackParent->Hurt(src, getDamage, angle, bTakedown, lr, shockForce, heavy, outRealDamage);
	return false;
}
