#include "CS_AmSoundWave.h"

CS_AmSoundWave::CS_AmSoundWave(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
    action_timecounter = action_timecounter_max = 100;
    vy = 0x800 / ts;
    //
    noDir = true;
}

void CS_AmSoundWave::Init(std::weak_ptr<Entity> self)
{
    if (gameFunc->pGameOption_difficulty)
        if (*gameFunc->pGameOption_difficulty == 0)
            bNormalMode = true;
    if (bNormalMode)
        vy = 0x400 / ts;
    Entity::Init(self);
}

void CS_AmSoundWave::Step()
{
    if (existTime > 0)
        existTime--;
    if (existTime == 0)
    {
        bLeave = true;
        attackState = false;
    }
    alpha = (BYTE)(0xff * action_timecounter / action_timecounter_max);
    color = RGBA(0xff, 0xff, 0xff, alpha);
    //ùΧ
    cbRect.left = cbRect.right = r;
    cbRect.top = cbRect.bottom = 8;
    GeneratePolyline(-r, r, (int)(r));
    DrawPolyline();
    if (bLeave && action_timecounter > 0)
    {
        action_timecounter--;
        if (action_timecounter == 0)
            Destroy();
    }
    //ִ˶
    Entity::Step();
}

void CS_AmSoundWave::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 5;
	if (lr == 0)
		*outAngle = 225;
	else
		*outAngle = 315;
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x800 / ts;
	*outHeavy = 2;
}

// 
void CS_AmSoundWave::GeneratePolyline(CS_AmSoundWave::Point start, CS_AmSoundWave::Point end, int segments)
{
    polyline.clear();
    polyline.push_back(start);

    float dx = (end.x - start.x) / segments;
    float dy = (end.y - start.y) / segments;

    for (int i = 1; i < segments; ++i)
    {
        // ֱ·ƫ
        float offsetX = (std::rand() % 100) / 100.0f - 0.5f;
        float offsetY = (std::rand() % 100) / 100.0f - 0.5f;

        CS_AmSoundWave::Point p;
        p.x = start.x + i * dx + offsetX * 1;
        p.y = start.y + i * dy + offsetY * 16;
        polyline.push_back(p);
    }
    polyline.push_back(end);
}

// 
void CS_AmSoundWave::DrawPolyline()
{
    if (polyline.size() < 2)
        return;
    fillList.clear();
    int index = 0;
    DWORD c = RGBA(0xff, 0xff, 0xff, alpha);
    for (size_t i = 0; i < polyline.size() - 1; ++i)
        index += AddFillLine(fillList, index, polyline[i].x, polyline[i].y, c, polyline[i + 1].x, polyline[i + 1].y, c, 1);
}

std::shared_ptr<Entity> CreateCS_AmSoundWave()
{
	return std::make_shared<CS_AmSoundWave>(nullptr);
}
