#include "CS_AmMonsterXPaw.h"

CS_AmMonsterXPaw::CS_AmMonsterXPaw(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 24;
	cbRect.top = cbRect.bottom = 32;
	//ö
	ani.png = L"CS_CaveStoryMod";
	color = RGBA(0xff, 0xff, 0xff, (BYTE)(appear_counter * 0xff / appear_counter_max));
}

void CS_AmMonsterXPaw::Init(std::weak_ptr<Entity> self)
{
	if (gameFunc->pGameOption_difficulty)
		if (*gameFunc->pGameOption_difficulty == 0)
			bNormalMode = true;
	Entity::Init(self);
}

void CS_AmMonsterXPaw::Step()
{
	switch (stateID)
	{
	case 0://
		if (appear_counter < appear_counter_max)
		{
			appear_counter++;
		}
		else
		{
			stateID = 1;
			//Ч
			auto wlightTail = std::make_shared<PeLightTail>(shared_from_this(), 40, 64.0f);
			lightTail = wlightTail;
			gameFunc->SetEntity(shared_from_this(), wlightTail);
		}	
		color = RGBA(0xff, 0xff, 0xff, (BYTE)(appear_counter * 0xff / appear_counter_max));
		break;
	case 1://ɨ
		if (lr == 0 && cbRect.cbLeft || lr != 0 && cbRect.cbRight)
		{
			stateID = 2;
			auto wlightTail = lightTail.lock();
			if (wlightTail)
				wlightTail->Leave();
			lightTail.reset();
		}
		vx = lr == 0 ? -0x1800 / ts : 0x1800 / ts;
		if(bNormalMode)
			vx = lr == 0 ? -0xc00 / ts : 0xc00 / ts;
		break;
	case 2://ʧ
		vx = 0;
		vy = 0;
		if (appear_counter > 0)
		{
			appear_counter--;
		}
		else
		{
			Destroy();
		}
		color = RGBA(0xff, 0xff, 0xff, (BYTE)(appear_counter * 0xff / appear_counter_max));
		break;
	}
	float srcY = y;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	y = srcY;
}

void CS_AmMonsterXPaw::SetState(int stateID, int lr)
{
	this->lr = lr;
	this->stateID = stateID;
	ani.sprite_index = lr == 0 ? L"am_monsterx_paw_l" : L"am_monsterx_paw_r";
}

void CS_AmMonsterXPaw::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (stateID == 1)
	{
		*outDamage = 10;
		if (lr == 0)
			*outAngle = 225;
		else
			*outAngle = 315;
		*outTakedown = true;
		*outElemType = 0;
		*outShockForce = 0x800 / ts;
		*outHeavy = 2;
	}
}

bool CS_AmMonsterXPaw::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	*outRealDamage = 0;
	return true;
}

std::shared_ptr<Entity> CreateCS_AmMonsterXPaw()
{
	return std::make_shared<CS_AmMonsterXPaw>(nullptr);
}
