#include "CS_AmBuyoBuyo.h"
#include "CS_PeSmoke.h"
#include "CS_PeGunShotSpark.h"
CS_AmBuyoBuyo::CS_AmBuyoBuyo(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	lr = parent->lr;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 6;
	hp_max = hp = 3;
	dropExp = 2;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_buyobuyo";
	//
	speedDir = true;
}

void CS_AmBuyoBuyo::Step()
{
	auto& ani_no = ani.image_index;
	if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		SetCS_PeGunShotSpark(shared_from_this(), x, y);
		Destroy();
		return;
	}
	if (attackParent.expired())
	{
		SetCS_PeGunShotSpark(shared_from_this(), x, y);
		Destroy();
		return;
	}
	else
	{
		auto wattackParent = attackParent.lock();
		if (wattackParent->hp == 0)
		{
			SetCS_PeGunShotSpark(shared_from_this(), x, y);
			Destroy();
			return;
		}
	}
	switch (act_no)
	{
	case 0:
		act_no = 1;
		vy = lr == 0 ? -0x600 / ts : 0x600 / ts;
		[[fallthrough]];
	case 1:
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (y < wplayer->y + 16 && y > wplayer->y - 16)
				{
					act_no = 10;
					tgt_x = x;
					tgt_y = y;
					lr = x > wplayer->x ? 0 : 1;
					vx = 2 * (Random(0, 1) - 0.5f);
					vy = 2 * (Random(0, 1) - 0.5f);
				}
			}
		}
		break;
	case 10:
		if (x < tgt_x)
			vx += 0x20 / ts;
		else
			vx -= 0x20 / ts;
		if (y < tgt_y)
			vy += 0x20 / ts;
		else
			vy -= 0x20 / ts;

		if (++act_wait > 300)
		{
			SetCS_PeGunShotSpark(shared_from_this(), x, y);
			Destroy();
			return;
		}
		if (lr == 0)
			tgt_x--;
		else
			tgt_x++;
		break;
	}
	if (vx > 0x400 / ts)
		vx = 0x400 / ts;
	if (vx < -0x400 / ts)
		vx = -0x400 / ts;

	if (vy > 0x400 / ts)
		vy = 0x400 / ts;
	if (vy < -0x400 / ts)
		vy = -0x400 / ts;

	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	if (++ani_wait > 6)
	{
		ani_wait = 0;
		++ani_no;
	}
	if (ani_no > 1)
		ani_no = 0;
}

void CS_AmBuyoBuyo::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_AmBuyoBuyo::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_053_enemy_hurt_small");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		Destroy();
	}
	return true;
}

void CS_AmBuyoBuyo::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void SetCS_AmBuyoBuyo(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmBuyoBuyo>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
}
