
;Sega CD Loader - MAIN-CPU user binary example
;(c) 2021 Rich Whitehouse

	include USERDEFS.INC

	ORG $FF0000

PRINT_VRAM_OFFSET	equ $C288
	
UserMain:
	lea UserVBlank,a1
	jsr SCD_SET_VINT
	
	;we have control of word ram coming in here. pass it back over, we don't need it for anything.
	move.b	#2,SCD_MEMORY_WPROT
	
	;p0 th to write
	move.b	#$40,$A10009
	
	;enable vint, set auto-increment
	move.l	#$81748F02,VDP_CTRL
	
	bsr WaitForVBlank
	
	lea		TestMessage,a0
	move.l	#$40000000|((PRINT_VRAM_OFFSET&$C000)>>$0E)|((PRINT_VRAM_OFFSET&$3FFF)<<$10),VDP_CTRL
	bsr DirectPrint
	
@mainLoop:
	bra @mainLoop


UserVBlank:
	st.b	VBlankFlag
	bsr ReadPort0
	move.b	InputDelta0,d0
	and.b	LastInput0,d0
	andi.b	#$F0,d0 ;test for a/b/c/start
	beq @noStart
	
	eor.b	#1,CommFlag
	move.b	CommFlag,SCD_COMMFLAG_WRITE
	
@noStart:
	
	rte

	
WaitForVBlank:
	clr.b	VBlankFlag
@stillWaiting:
	tst.b	VBlankFlag
	beq		@stillWaiting
	rts


DirectPrint:
	lea		VDP_DATA,a1
	moveq	#0,d0
@nextChar:
	move.b	(a0)+,d0
	beq @exit
	move.w	d0,(a1)
	bra @nextChar
	
@exit:
	rts

	
ReadPort0:
	move.w	#$100,$A11100
@waitForBusRequest:
	btst	#0,$A11100
	bne @waitForBusRequest

	;high
	move.b	#$40,$A10003
	nop
	nop
	move.b	$A10003,d0
	andi.b	#$3F,d0
	;low
	move.b	#$0,$A10003
	nop
	nop
	move.b	$A10003,d1
	andi.b	#$30,d1
	lsl.b	#2,d1
	or.b	d0,d1
	eori.b	#$FF,d1

	move.w	#0,$A11100

	move.b	LastInput0,d0
	move.b	d1,LastInput0
	eor.b	d0,d1
	move.b	d1,InputDelta0

	rts


	;data
TestMessage:				dc.b "Nice BIOS font you've got there!",0

	EVEN
LastInput0:					ds.b 1
InputDelta0:				ds.b 1
VBlankFlag:					ds.b 1
CommFlag:					ds.b 1
