meta:
  id: piyopiyo_track
  title: PiyoPiyo Track / Pixel Music Data
  application:
    - PiyoPiyo
  file-extension: pmd
  license: CC0-1.0
  endian: le
doc: |
  PMD (assumed to be Pixel Music Data) is a music format used in the freeware game Ikachan, the predecessor to Cave Story.
seq:
  - id: header
    type: header
  - id: padding
    type: u1
    repeat: expr
    repeat-expr: header.data_offset - 0x418
  - id: tracks
    type: track(header.song_beats)
    repeat: expr
    repeat-expr: 4
    doc: "1, 2, 3, then P"
types:
  header:
    seq:
      - id: magic
        contents: 'PMD'
      - id: flags
        type: u1
        doc: 0x80
      - id: data_offset
        type: u4
      - id: beat_time_ms
        type: s4
      - id: loop_start
        type: s4
      - id: loop_end
        type: s4
      - id: song_beats
        type: s4
      - id: wave_track_header
        type: wave_track_header
        repeat: expr
        repeat-expr: 3
      - id: drum_track_volume
        type: s4
  wave_track_header:
    seq:
      - id: octave
        type: u1
      - id: icon
        type: u1
      - id: padding_a
        type: u2
      - id: env_length
        type: u4
        doc: "in 1/22050 second units - stretches out the envelope table below"
      - id: volume
        type: u4
      - id: padding_b
        type: u8
      - id: waveform
        type: s1
        repeat: expr
        repeat-expr: 256
      - id: envelope
        type: s1
        repeat: expr
        repeat-expr: 64
  track:
    params:
      - id: song_beats
        type: s4
    seq:
      - id: frames
        type: frame
        repeat: expr
        repeat-expr: song_beats
  frame:
    seq:
      - id: notes
        type: u1
        repeat: expr
        repeat-expr: 3
        doc: "lowest bit/first byte = lowest pitch"
      - id: pan
        type: u1
        doc: "0 = no change ; 1-7 = set pan from L to R ; 4 = centre"

