/*
 * Part of the PiyoPiyoJ project.
 * (PiyoPiyo Java)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *                    Version 2, December 2004 
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net> 
 *
 * Everyone is permitted to copy and distribute verbatim or modified 
 * copies of this license document, and changing it is allowed as long 
 * as the name is changed. 
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION 
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */
package piyopiyoj.games.ui;

import gabien.ui.*;
import gabien.ui.elements.*;
import gabien.uslx.append.*;
import libpiyo.PiyoPiyoWaveTrack;
import piyopiyoj.Game;

public class UIWaveTrackHeaderEditor extends UIElement.UIPanel {
    public final PiyoPiyoWaveTrack theTrack;
    public UIGraphEditor waveForm, envelope;

    public UILabel volumeLabel = new UILabel("Track Volume:", 16);
    public UILabel lengthLabel = new UILabel("Envelope Len:", 16);
    public UILabel octaveLabel = new UILabel("Track Octave:", 16);
    public UINumberBox volumeBox = new UINumberBox(0, 16);
    public UINumberBox lengthBox = new UINumberBox(0, 16);
    public UINumberBox octaveBox = new UINumberBox(0, 16);

    public UIWaveTrackHeaderEditor(final Game root, PiyoPiyoWaveTrack track) {
        super(640, 12 * (8 + 24));
        waveForm = new UIGraphEditor(root, track.waveForm, true);
        envelope = new UIGraphEditor(root, track.envelope, false);
        theTrack = track;
        layoutAddElement(waveForm);
        layoutAddElement(envelope);

        layoutAddElement(volumeLabel);

        volumeBox.onEdit = new Runnable() {
            @Override
            public void run() {
                root.startModifications("WaveTrack Volume");
                theTrack.volume = (int) volumeBox.getNumber();
                root.endModifications();
                root.playerControls.regenWaveforms();
            }
        };
        layoutAddElement(volumeBox);

        layoutAddElement(lengthLabel);

        lengthBox.onEdit = new Runnable() {
            @Override
            public void run() {
                root.startModifications("WaveTrack Envelope Length");
                theTrack.length = (int) lengthBox.getNumber();
                root.endModifications();
                root.playerControls.regenWaveforms();
            }
        };
        layoutAddElement(lengthBox);

        layoutAddElement(octaveLabel);

        octaveBox.onEdit = new Runnable() {
            @Override
            public void run() {
                root.startModifications("WaveTrack Octave");
                theTrack.octave = (int) octaveBox.getNumber();
                root.endModifications();
                root.playerControls.regenWaveforms();
            }
        };
        layoutAddElement(octaveBox);
    }

    @Override
    protected void layoutRunImpl() {
        Size elementBounds = getSize();
        waveForm.setForcedBounds(this, new Rect(0, 0, elementBounds.width, 256));
        envelope.setForcedBounds(this, new Rect(0, 257, 0x80, 127));

        volumeLabel.setForcedBounds(this, new Rect(0x81, 257, 220, 18));
        lengthLabel.setForcedBounds(this, new Rect(0x81, 275, 220, 18));
        octaveLabel.setForcedBounds(this, new Rect(0x81, 293, 220, 18));
        volumeBox.setForcedBounds(this, new Rect(0x81 + 220, 257, elementBounds.width - (0x81 + 221), 18));
        lengthBox.setForcedBounds(this, new Rect(0x81 + 220, 275, elementBounds.width - (0x81 + 221), 18));
        octaveBox.setForcedBounds(this, new Rect(0x81 + 220, 293, elementBounds.width - (0x81 + 221), 18));
    }

    public void refresh() {
        volumeBox.setNumber(theTrack.volume);
        lengthBox.setNumber(theTrack.length);
        octaveBox.setNumber(theTrack.octave);
    }
}
