/*
 * Part of the PiyoPiyoJ project.
 * (PiyoPiyo Java)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *                    Version 2, December 2004 
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net> 
 *
 * Everyone is permitted to copy and distribute verbatim or modified 
 * copies of this license document, and changing it is allowed as long 
 * as the name is changed. 
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION 
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */
package piyopiyoj.games.ui;

import gabien.GaBIEn;
import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOFormat;
import gabien.media.audio.AudioIOSample;
import gabien.media.audio.AudioIOSource;
import gabien.media.audio.PCMConversions;
import gabien.media.audio.fileio.ReadAnySupportedAudioSource;
import gabien.ui.*;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UITextButton;
import gabien.ui.layouts.UISplitterLayout;
import gabien.wsi.*;
import piyopiyoj.*;

/**
 * Handles play control logic for a PiyoPiyoPlayer.
 */
public class UIPlayerControls extends UIElement.UIProxy {

    public final PlayerControls corePlayer;

    private UITextButton refTrack = new UITextButton("Ref", 16, new Runnable() {
        @Override
        public void run() {
            corePlayer.useRefTrack = refTrack.state;
        }
    }).togglable(false);

    private UITextButton refSetTrack = new UITextButton("(Set)", 16, new Runnable() {
        @Override
        public void run() {
            GaBIEn.startFileBrowser("Load Reference Track...", false, "", (s) -> {
                try {
                    AudioIOSource src = ReadAnySupportedAudioSource.open(GaBIEn.getInFile(s), true);
                    AudioIOSample smp = new AudioIOSample(src, AudioIOFormat.F_F32);
                    AudioIOSample rsmp = smp.resample(new AudioIOCRSet(2, 22050), false);
                    int[] tmp = new int[2];
                    short[] res = new short[rsmp.length * 2];
                    for (int i = 0; i < res.length; i += 2) {
                        rsmp.getS32(i / 2, tmp);
                        PCMConversions.pcmS32ToS16(tmp, 0, res, i, 2);
                    }
                    corePlayer.refTrack = res;
                    refSetTrack.setText("(Ok!)");
                } catch (Exception e) {
                    e.printStackTrace();
                    refSetTrack.setText("(Err)");
                }
            });
        }
    });

    private UITextButton play = new UITextButton(">", 16, new Runnable() {
        @Override
        public void run() {
            playReverse.state = false;
            corePlayer.setPlaying(play.state);
            corePlayer.reverse = false;
        }
    }).togglable(false);

    private UITextButton playReverse = new UITextButton("<", 16, new Runnable() {
        @Override
        public void run() {
            play.state = false;
            corePlayer.setPlaying(playReverse.state);
            corePlayer.reverse = true;
        }
    }).togglable(false);

    private UITextButton halfSpeed = new UITextButton("/", 16, new Runnable() {
        @Override
        public void run() {
            corePlayer.halfSpeed = halfSpeed.state;
        }
    }).togglable(false);

    private UITextButton toStart = new UITextButton("<<", 16, new Runnable() {
        @Override
        public void run() {
            corePlayer.playerLock.lock();
            corePlayer.setCurrentFrame(0);
            corePlayer.playerLock.unlock();
        }
    });
    private UITextButton toEnd = new UITextButton(">>", 16, new Runnable() {
        @Override
        public void run() {
            corePlayer.playerLock.lock();
            corePlayer.setCurrentFrame(corePlayer.coreFile.loopEnd);
            corePlayer.playerLock.unlock();
        }
    });

    private UITextButton loop = new UITextButton("Loop", 16, new Runnable() {
        @Override
        public void run() {
            corePlayer.setHandleLoop(loop.state);
        }
    }).togglable(false);

    private UILabel songDetails = new UILabel("insert details", 16);

    public UIPlayerControls(PlayerControls myPlayer) {
        corePlayer = myPlayer;

        boolean playing = corePlayer.getPlaying();
        play.state = playing && (!corePlayer.reverse);
        playReverse.state = playing && corePlayer.reverse;
        halfSpeed.state = corePlayer.halfSpeed;
        loop.state = corePlayer.getHandleLoop();

        proxySetElement(UISplitterLayout.produceSideAlignedList(true, false,
            songDetails,
            refTrack,
            refSetTrack,
            loop,
            toStart,
            playReverse,
            halfSpeed,
            play,
            toEnd
        ), true);
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {
        double frameInterp = corePlayer.getFrameInterpolatedPrecise();
        int currentFrame = (int) Math.floor(frameInterp);
        double time = convertTime(0, frameInterp * corePlayer.coreFile.beatTime());
        double timeEnd = convertTime(corePlayer.coreFile.loopEnd, 0);
        songDetails.setText(currentFrame + "/" + corePlayer.coreFile.getFrameCount() + " (" + time + "s/" + timeEnd + "s)");
        super.update(deltaTime, selected, peripherals);
    }

    private double convertTime(int frames, double offset) {
        double time = (frames * corePlayer.coreFile.beatTime()) + offset;
        time *= 10;
        time = (int) time;
        time /= 10;
        return time;
    }
}
