/*
 * Part of the PiyoPiyoJ project.
 * (PiyoPiyo Java)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *                    Version 2, December 2004 
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net> 
 *
 * Everyone is permitted to copy and distribute verbatim or modified 
 * copies of this license document, and changing it is allowed as long 
 * as the name is changed. 
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION 
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */
package piyopiyoj.games.ui;

import gabien.*;
import gabien.wsi.*;
import gabien.render.*;
import gabien.ui.*;
import gabien.uslx.append.Size;
import piyopiyoj.*;

import java.util.WeakHashMap;

public class UIGraphEditor extends UIElement implements IPointerReceiver {
    public final int[] targetArray;
    public final boolean signed;
    public int leftOffset = 0;
    public WeakHashMap<IPointer, Integer> lastPos = new WeakHashMap<IPointer, Integer>();
    public final Game root;
    public int working = 0;

    public UIGraphEditor(Game r, int[] coreArray, boolean s) {
        super(coreArray.length * 2, 256);
        root = r;
        targetArray = coreArray;
        signed = s;
    }

    @Override
    public void update(double deltaTime, boolean selected, IPeripherals peripherals) {

    }

    @Override
    public void renderLayer(IGrDriver igd, UILayer layer) {
        if (layer != UILayer.Content)
            return;
        IImage im = GaBIEn.getImageEx("graph.png", false, true);
        Size elementBounds = getSize();
        int range = elementBounds.height;
        // Envelopes are "signed but not". It's weird.
        // Basically, they have the 0x7F limit suggesting they are signed,
        // but the UI doesn't allow negative values.
        // I may add in colouring to show the "negative" values and make these consistent in future.
        // As for the waveform:
        // The "xor 0x80" stuff is so that 0 is in the center.
        int s1 = (signed ? 255 : 127);
        igd.blitScaledImage(2, 2, 2, signed ? 4 : 2, 0, 0, elementBounds.width, elementBounds.height, im);
        igd.blitScaledImage(0, 2, 2, signed ? 4 : 2, leftOffset, 0, targetArray.length * 2, elementBounds.height, im);
        for (int i = -((leftOffset + 1) / 2); i < targetArray.length + ((leftOffset + 3) / 2); i++) {
            int sp = i;
            while (sp < 0)
                sp += targetArray.length;
            int ei = targetArray[sp % targetArray.length];
            if (signed)
                ei ^= 0x80;
            ei = s1 - ei;
            int srcX = 0;
            if (i < 0)
                srcX = 2;
            if (i >= targetArray.length)
                srcX = 2;
            igd.blitImage(srcX, 0, 2, 2, (i * 2) + leftOffset, ((ei * range) / s1) - 1, im);
        }
    }

    @Override
    public IPointerReceiver handleNewPointer(IPointer state) {
        return this;
    }
    
    @Override
    public void handlePointerBegin(IPointer state) {
        working++;
        if (working == 1)
            root.startModifications("GraphEditor");
        handlePointerUpdate(state);
    }

    @Override
    public void handlePointerEnd(IPointer state) {
        handlePointerUpdate(state);
        lastPos.remove(state);
        working--;
        if (working == 0) {
            root.endModifications();
            root.playerControls.regenWaveforms();
        }
        if (working < 0)
            throw new RuntimeException("Pointer count < 0 - UI framework malfunction");
    }

    @Override
    public void handlePointerUpdate(IPointer state) {
        if (state.getType() == IPointer.PointerType.Generic) {
            int v = (state.getX() - leftOffset) / 2;
            int s1 = (signed ? 255 : 127);
            double position = (state.getY() + 1) / (getSize().height - 1.0d);
            position *= (double) s1;
            int ei = (int) position;
            if (ei > s1)
                ei = s1;
            if (ei < 0)
                ei = 0;
            ei = s1 - ei;
            if (signed)
                ei ^= 0x80;
            mainPointerCore(v, ei, state);
        }
    }

    private void mainPointerCore(int v, int ei, IPointer state) {
        int i = v;
        Integer i2 = lastPos.get(state);
        if (i2 != null)
            i = i2;
        for (int j = Math.min(i, v); j <= Math.max(i, v); j++) {
            int j2 = j;
            if (signed) {
                while (j2 < 0)
                    j2 += targetArray.length;
                j2 %= targetArray.length;
            } else {
                if (j2 < 0)
                    j2 = 0;
                if (j2 >= targetArray.length)
                    j2 = targetArray.length - 1;
            }
            targetArray[j2] = ei;
        }
        lastPos.put(state, v);
    }

    @Override
    protected void layoutRunImpl() {
        leftOffset = (getSize().width - (targetArray.length * 2)) / 2;
    }
}
