/*
 * Part of the PiyoPiyoJ project.
 * (PiyoPiyo Java)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *                    Version 2, December 2004 
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net> 
 *
 * Everyone is permitted to copy and distribute verbatim or modified 
 * copies of this license document, and changing it is allowed as long 
 * as the name is changed. 
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION 
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */

package piyopiyoj.games.edittools;

import gabien.ui.UIElement;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UIPublicPanel;
import gabien.ui.layouts.UISplitterLayout;
import piyopiyoj.games.NotesheetGame;

public class SelectEditTool implements EditTool {

    @Override
    public UIElement toolOpened(NotesheetGame editor) {
        UILabel text = new UILabel("Selection Tool:\n Click/drag over the sheet to select an area.", 16);
        return NoteEditTool.generateBack(UISplitterLayout.produceSideAlignedList(false, true,
            text,
            new UISplitterLayout(NoteEditTool.generatePastePanel(editor), new UIPublicPanel(0, 0), false, 0),
            new UIPublicPanel(0, 0)
        ), editor);
    }

    @Override
    public void onClick(int frameIndex, int pos, int button, NotesheetGame editor) {
        if (button == 1)
            editor.noteDisplay.selectedStart = Math.max(0, frameIndex);
    }

    @Override
    public void onDrag(int frameIndex, int pos, NotesheetGame editor) {
        editor.noteDisplay.selectedEnd = Math.max(0, frameIndex);
    }

}
