/*
 * Part of the PiyoPiyoJ project.
 * (PiyoPiyo Java)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *                    Version 2, December 2004 
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net> 
 *
 * Everyone is permitted to copy and distribute verbatim or modified 
 * copies of this license document, and changing it is allowed as long 
 * as the name is changed. 
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION 
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */

package piyopiyoj.games.edittools;

import gabien.ui.UIElement;
import libpiyo.PiyoPiyoFrame;
import piyopiyoj.games.NotesheetGame;

public class PasteEditTool implements EditTool {
    public final boolean allTracks;

    public PasteEditTool(boolean at) {
        allTracks = at;
    }

    @Override
    public UIElement toolOpened(NotesheetGame editor) {
        return NoteEditTool.generateTmp(allTracks ? "Paste All Tracks:\n Click at paste location." : "Paste Track Tool:\n Click at paste location.", editor);
    }

    @Override
    public void onClick(int frameIndex, int pos, int button, NotesheetGame editor) {
        if (button == 1) {
            if (!allTracks) {
                pasteForTrack(frameIndex, editor.noteDisplay.track, editor);
            } else {
                for (int i = 0; i < 4; i++)
                    pasteForTrack(frameIndex, i, editor);
            }
            editor.noteDisplay.selectedEnd += frameIndex - editor.noteDisplay.selectedStart;
            editor.noteDisplay.selectedStart = frameIndex;
        }
    }

    private void pasteForTrack(int frameIndex, int track, NotesheetGame editor) {
        if (editor.noteDisplay.selectedEnd < editor.noteDisplay.selectedStart)
            return;
        PiyoPiyoFrame[] source = new PiyoPiyoFrame[(editor.noteDisplay.selectedEnd - editor.noteDisplay.selectedStart) + 1];
        for (int i = editor.noteDisplay.selectedStart; i <= editor.noteDisplay.selectedEnd; i++) {
            PiyoPiyoFrame frameA = editor.root.coreFile.getFrameOrNull(i, track);
            if (frameA == null) {
                frameA = new PiyoPiyoFrame();
            } else {
                frameA = new PiyoPiyoFrame(frameA);
            }
            source[i - editor.noteDisplay.selectedStart] = frameA;
        }
        for (int i = 0; i < source.length; i++) {
            PiyoPiyoFrame frameA = source[i];
            PiyoPiyoFrame frameB = editor.root.coreFile.ensureFrame(frameIndex + i, track);
            for (int p = 0; p < 24; p++)
                frameB.hitNotes[p] = frameA.hitNotes[p];
            frameB.panValue = frameA.panValue;
        }
    }

    @Override
    public void onDrag(int frameIndex, int pos, NotesheetGame editor) {
    }

}
