/*
 * Part of the PiyoPiyoJ project.
 * (PiyoPiyo Java)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *                    Version 2, December 2004 
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net> 
 *
 * Everyone is permitted to copy and distribute verbatim or modified 
 * copies of this license document, and changing it is allowed as long 
 * as the name is changed. 
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION 
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */

package piyopiyoj.games.edittools;

import gabien.ui.UIElement;
import gabien.ui.elements.*;
import gabien.ui.layouts.UISplitterLayout;
import piyopiyoj.games.NotesheetGame;

public class NoteEditTool extends DefaultSemanticsTool {

    @Override
    public UIElement toolOpened(final NotesheetGame editor) {
        UIElement export = new UITextButton("Export", 16, new Runnable() {
            
            @Override
            public void run() {
                editor.selectTool(new ExportEditTool());
            }
        });

        UIElement loopBounds = UISplitterLayout.produceSideAlignedList(false, false, new UILabel("Loop Bounds: ", 16), new UITextButton("Start", 16, new Runnable() {
            @Override
            public void run() {
                editor.selectTool(new LoopBoundsTool(true));
            }
        }), new UITextButton("End", 16, new Runnable() {
            @Override
            public void run() {
                editor.selectTool(new LoopBoundsTool(false));
            }
        }), new UIPublicPanel(16, 0), export, new UIPublicPanel(0, 0));

        UITextButton select = new UITextButton("Select", 16, new Runnable() {
            @Override
            public void run() {
                editor.selectTool(new SelectEditTool());
            }
        });

        UITextButton beatTap = new UITextButton("BeatTap", 16, () -> {
            editor.selectTool(new BeatTapEditTool());
        });

        UIElement paste = UISplitterLayout.produceSideAlignedList(true, false,
            new UIPublicPanel(0, 0),
            select,
            new UIPublicPanel(16, 0),
            beatTap,
            generatePastePanel(editor)
        );

        UIElement left = UISplitterLayout.produceSideAlignedList(true, true,
                new UIPublicPanel(0, 0),
                loopBounds
        );

        UIElement right = UISplitterLayout.produceSideAlignedList(true, true,
                new UIPublicPanel(0, 0),
                paste
        );

        return new UISplitterLayout(new UILabel("Click to place or remove notes. Press keys to test notes.", 16), new UISplitterLayout(left, right, false, 0.5d), true, 1);
    }

    public static UIElement generatePastePanel(final NotesheetGame editor) {
        return UISplitterLayout.produceSideAlignedList(true, false,
            new UILabel(" Paste: ", 16), new UITextButton("All", 16, new Runnable() {
                @Override
                public void run() {
                    editor.selectTool(new PasteEditTool(true));
                }
            }), new UITextButton("Track", 16, new Runnable() {
                @Override
                public void run() {
                    editor.selectTool(new PasteEditTool(false));
                }
            }
        ));
    }
    public static UIElement generateTmp(String text, final NotesheetGame editor) {
        return generateBack(new UILabel(text, 16), editor);
    }
    public static UIElement generateBack(UIElement content, final NotesheetGame editor) {
        return new UISplitterLayout(new UITextButton("<", 16, new Runnable() {
            @Override
            public void run() {
                editor.selectTool(new NoteEditTool());
            }
        }), content, false, 0);
    }
}
