/*
 * Part of the PiyoPiyoJ project.
 * (PiyoPiyo Java)
 *
 *        DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *                    Version 2, December 2004 
 *
 * Modified by 20kdc <asdd2808@gmail.com> to remove expletives
 * Original copyright (C) 2004 Sam Hocevar <sam@hocevar.net> 
 *
 * Everyone is permitted to copy and distribute verbatim or modified 
 * copies of this license document, and changing it is allowed as long 
 * as the name is changed. 
 *
 *            DO WHATEVER YOU WANT TO PUBLIC LICENSE 
 *   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION 
 *
 *  0. You just DO WHATEVER YOU WANT TO.
 */

package piyopiyoj.games.edittools;

import gabien.ui.UIElement;
import piyopiyoj.games.NotesheetGame;

public class LoopBoundsTool implements EditTool {

    public final boolean start;

    public LoopBoundsTool(boolean s) {
        start = s;
    }

    @Override
    public UIElement toolOpened(NotesheetGame editor) {
        return NoteEditTool.generateTmp("Loop Boundaries Tool: " + (start ? "Start" : "End") + "\n Click to place the loop boundary.", editor);
    }

    @Override
    public void onClick(int frameIndex, int pos, int button,
                        NotesheetGame editor) {
        if (button == 1) {
            if (start) {
                editor.root.coreFile.loopStart = frameIndex;
            } else {
                editor.root.coreFile.loopEnd = frameIndex;
            }
        }
    }

    @Override
    public void onDrag(int frameIndex, int pos, NotesheetGame editor) {
        if (start) {
            editor.root.coreFile.loopStart = frameIndex;
        } else {
            editor.root.coreFile.loopEnd = frameIndex;
        }
    }

}
